/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AlternatePathHint;
import software.amazon.awssdk.services.ec2.model.AlternatePathHintListCopier;
import software.amazon.awssdk.services.ec2.model.AnalysisStatus;
import software.amazon.awssdk.services.ec2.model.ArnListCopier;
import software.amazon.awssdk.services.ec2.model.Explanation;
import software.amazon.awssdk.services.ec2.model.ExplanationListCopier;
import software.amazon.awssdk.services.ec2.model.PathComponent;
import software.amazon.awssdk.services.ec2.model.PathComponentListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInsightsAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInsightsAnalysis> {
    private static final SdkField<String> NETWORK_INSIGHTS_ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAnalysisId").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::networkInsightsAnalysisId)).setter(NetworkInsightsAnalysis.setter(Builder::networkInsightsAnalysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisId").unmarshallLocationName("networkInsightsAnalysisId").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ANALYSIS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAnalysisArn").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::networkInsightsAnalysisArn)).setter(NetworkInsightsAnalysis.setter(Builder::networkInsightsAnalysisArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisArn").unmarshallLocationName("networkInsightsAnalysisArn").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsPathId").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::networkInsightsPathId)).setter(NetworkInsightsAnalysis.setter(Builder::networkInsightsPathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId").unmarshallLocationName("networkInsightsPathId").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAccounts").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::additionalAccounts)).setter(NetworkInsightsAnalysis.setter(Builder::additionalAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAccountSet").unmarshallLocationName("additionalAccountSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FILTER_IN_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterInArns").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::filterInArns)).setter(NetworkInsightsAnalysis.setter(Builder::filterInArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterInArnSet").unmarshallLocationName("filterInArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FILTER_OUT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterOutArns").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::filterOutArns)).setter(NetworkInsightsAnalysis.setter(Builder::filterOutArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOutArnSet").unmarshallLocationName("filterOutArnSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartDate").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::startDate)).setter(NetworkInsightsAnalysis.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").unmarshallLocationName("startDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::statusAsString)).setter(NetworkInsightsAnalysis.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::statusMessage)).setter(NetworkInsightsAnalysis.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WarningMessage").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::warningMessage)).setter(NetworkInsightsAnalysis.setter(Builder::warningMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarningMessage").unmarshallLocationName("warningMessage").build()}).build();
    private static final SdkField<Boolean> NETWORK_PATH_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NetworkPathFound").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::networkPathFound)).setter(NetworkInsightsAnalysis.setter(Builder::networkPathFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPathFound").unmarshallLocationName("networkPathFound").build()}).build();
    private static final SdkField<List<PathComponent>> FORWARD_PATH_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ForwardPathComponents").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::forwardPathComponents)).setter(NetworkInsightsAnalysis.setter(Builder::forwardPathComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardPathComponentSet").unmarshallLocationName("forwardPathComponentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PathComponent>> RETURN_PATH_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReturnPathComponents").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::returnPathComponents)).setter(NetworkInsightsAnalysis.setter(Builder::returnPathComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPathComponentSet").unmarshallLocationName("returnPathComponentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Explanation>> EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Explanations").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::explanations)).setter(NetworkInsightsAnalysis.setter(Builder::explanations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplanationSet").unmarshallLocationName("explanationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Explanation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<AlternatePathHint>> ALTERNATE_PATH_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlternatePathHints").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::alternatePathHints)).setter(NetworkInsightsAnalysis.setter(Builder::alternatePathHints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternatePathHintSet").unmarshallLocationName("alternatePathHintSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlternatePathHint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUGGESTED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestedAccounts").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::suggestedAccounts)).setter(NetworkInsightsAnalysis.setter(Builder::suggestedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedAccountSet").unmarshallLocationName("suggestedAccountSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NetworkInsightsAnalysis.getter(NetworkInsightsAnalysis::tags)).setter(NetworkInsightsAnalysis.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ANALYSIS_ARN_FIELD, NETWORK_INSIGHTS_PATH_ID_FIELD, ADDITIONAL_ACCOUNTS_FIELD, FILTER_IN_ARNS_FIELD, FILTER_OUT_ARNS_FIELD, START_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WARNING_MESSAGE_FIELD, NETWORK_PATH_FOUND_FIELD, FORWARD_PATH_COMPONENTS_FIELD, RETURN_PATH_COMPONENTS_FIELD, EXPLANATIONS_FIELD, ALTERNATE_PATH_HINTS_FIELD, SUGGESTED_ACCOUNTS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkInsightsAnalysis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInsightsAnalysisId;
    private final String networkInsightsAnalysisArn;
    private final String networkInsightsPathId;
    private final List<String> additionalAccounts;
    private final List<String> filterInArns;
    private final List<String> filterOutArns;
    private final Instant startDate;
    private final String status;
    private final String statusMessage;
    private final String warningMessage;
    private final Boolean networkPathFound;
    private final List<PathComponent> forwardPathComponents;
    private final List<PathComponent> returnPathComponents;
    private final List<Explanation> explanations;
    private final List<AlternatePathHint> alternatePathHints;
    private final List<String> suggestedAccounts;
    private final List<Tag> tags;

    private NetworkInsightsAnalysis(BuilderImpl builder) {
        this.networkInsightsAnalysisId = builder.networkInsightsAnalysisId;
        this.networkInsightsAnalysisArn = builder.networkInsightsAnalysisArn;
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.additionalAccounts = builder.additionalAccounts;
        this.filterInArns = builder.filterInArns;
        this.filterOutArns = builder.filterOutArns;
        this.startDate = builder.startDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.warningMessage = builder.warningMessage;
        this.networkPathFound = builder.networkPathFound;
        this.forwardPathComponents = builder.forwardPathComponents;
        this.returnPathComponents = builder.returnPathComponents;
        this.explanations = builder.explanations;
        this.alternatePathHints = builder.alternatePathHints;
        this.suggestedAccounts = builder.suggestedAccounts;
        this.tags = builder.tags;
    }

    public final String networkInsightsAnalysisId() {
        return this.networkInsightsAnalysisId;
    }

    public final String networkInsightsAnalysisArn() {
        return this.networkInsightsAnalysisArn;
    }

    public final String networkInsightsPathId() {
        return this.networkInsightsPathId;
    }

    public final boolean hasAdditionalAccounts() {
        return this.additionalAccounts != null && !(this.additionalAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> additionalAccounts() {
        return this.additionalAccounts;
    }

    public final boolean hasFilterInArns() {
        return this.filterInArns != null && !(this.filterInArns instanceof SdkAutoConstructList);
    }

    public final List<String> filterInArns() {
        return this.filterInArns;
    }

    public final boolean hasFilterOutArns() {
        return this.filterOutArns != null && !(this.filterOutArns instanceof SdkAutoConstructList);
    }

    public final List<String> filterOutArns() {
        return this.filterOutArns;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final AnalysisStatus status() {
        return AnalysisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String warningMessage() {
        return this.warningMessage;
    }

    public final Boolean networkPathFound() {
        return this.networkPathFound;
    }

    public final boolean hasForwardPathComponents() {
        return this.forwardPathComponents != null && !(this.forwardPathComponents instanceof SdkAutoConstructList);
    }

    public final List<PathComponent> forwardPathComponents() {
        return this.forwardPathComponents;
    }

    public final boolean hasReturnPathComponents() {
        return this.returnPathComponents != null && !(this.returnPathComponents instanceof SdkAutoConstructList);
    }

    public final List<PathComponent> returnPathComponents() {
        return this.returnPathComponents;
    }

    public final boolean hasExplanations() {
        return this.explanations != null && !(this.explanations instanceof SdkAutoConstructList);
    }

    public final List<Explanation> explanations() {
        return this.explanations;
    }

    public final boolean hasAlternatePathHints() {
        return this.alternatePathHints != null && !(this.alternatePathHints instanceof SdkAutoConstructList);
    }

    public final List<AlternatePathHint> alternatePathHints() {
        return this.alternatePathHints;
    }

    public final boolean hasSuggestedAccounts() {
        return this.suggestedAccounts != null && !(this.suggestedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> suggestedAccounts() {
        return this.suggestedAccounts;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAccounts() ? this.additionalAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterInArns() ? this.filterInArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterOutArns() ? this.filterOutArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPathFound());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForwardPathComponents() ? this.forwardPathComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReturnPathComponents() ? this.returnPathComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExplanations() ? this.explanations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternatePathHints() ? this.alternatePathHints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestedAccounts() ? this.suggestedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsAnalysis)) {
            return false;
        }
        NetworkInsightsAnalysis other = (NetworkInsightsAnalysis)obj;
        return Objects.equals(this.networkInsightsAnalysisId(), other.networkInsightsAnalysisId()) && Objects.equals(this.networkInsightsAnalysisArn(), other.networkInsightsAnalysisArn()) && Objects.equals(this.networkInsightsPathId(), other.networkInsightsPathId()) && this.hasAdditionalAccounts() == other.hasAdditionalAccounts() && Objects.equals(this.additionalAccounts(), other.additionalAccounts()) && this.hasFilterInArns() == other.hasFilterInArns() && Objects.equals(this.filterInArns(), other.filterInArns()) && this.hasFilterOutArns() == other.hasFilterOutArns() && Objects.equals(this.filterOutArns(), other.filterOutArns()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.warningMessage(), other.warningMessage()) && Objects.equals(this.networkPathFound(), other.networkPathFound()) && this.hasForwardPathComponents() == other.hasForwardPathComponents() && Objects.equals(this.forwardPathComponents(), other.forwardPathComponents()) && this.hasReturnPathComponents() == other.hasReturnPathComponents() && Objects.equals(this.returnPathComponents(), other.returnPathComponents()) && this.hasExplanations() == other.hasExplanations() && Objects.equals(this.explanations(), other.explanations()) && this.hasAlternatePathHints() == other.hasAlternatePathHints() && Objects.equals(this.alternatePathHints(), other.alternatePathHints()) && this.hasSuggestedAccounts() == other.hasSuggestedAccounts() && Objects.equals(this.suggestedAccounts(), other.suggestedAccounts()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkInsightsAnalysis").add("NetworkInsightsAnalysisId", (Object)this.networkInsightsAnalysisId()).add("NetworkInsightsAnalysisArn", (Object)this.networkInsightsAnalysisArn()).add("NetworkInsightsPathId", (Object)this.networkInsightsPathId()).add("AdditionalAccounts", this.hasAdditionalAccounts() ? this.additionalAccounts() : null).add("FilterInArns", this.hasFilterInArns() ? this.filterInArns() : null).add("FilterOutArns", this.hasFilterOutArns() ? this.filterOutArns() : null).add("StartDate", (Object)this.startDate()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("WarningMessage", (Object)this.warningMessage()).add("NetworkPathFound", (Object)this.networkPathFound()).add("ForwardPathComponents", this.hasForwardPathComponents() ? this.forwardPathComponents() : null).add("ReturnPathComponents", this.hasReturnPathComponents() ? this.returnPathComponents() : null).add("Explanations", this.hasExplanations() ? this.explanations() : null).add("AlternatePathHints", this.hasAlternatePathHints() ? this.alternatePathHints() : null).add("SuggestedAccounts", this.hasSuggestedAccounts() ? this.suggestedAccounts() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAnalysisId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAnalysisId()));
            }
            case "NetworkInsightsAnalysisArn": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAnalysisArn()));
            }
            case "NetworkInsightsPathId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsPathId()));
            }
            case "AdditionalAccounts": {
                return Optional.ofNullable(clazz.cast(this.additionalAccounts()));
            }
            case "FilterInArns": {
                return Optional.ofNullable(clazz.cast(this.filterInArns()));
            }
            case "FilterOutArns": {
                return Optional.ofNullable(clazz.cast(this.filterOutArns()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "WarningMessage": {
                return Optional.ofNullable(clazz.cast(this.warningMessage()));
            }
            case "NetworkPathFound": {
                return Optional.ofNullable(clazz.cast(this.networkPathFound()));
            }
            case "ForwardPathComponents": {
                return Optional.ofNullable(clazz.cast(this.forwardPathComponents()));
            }
            case "ReturnPathComponents": {
                return Optional.ofNullable(clazz.cast(this.returnPathComponents()));
            }
            case "Explanations": {
                return Optional.ofNullable(clazz.cast(this.explanations()));
            }
            case "AlternatePathHints": {
                return Optional.ofNullable(clazz.cast(this.alternatePathHints()));
            }
            case "SuggestedAccounts": {
                return Optional.ofNullable(clazz.cast(this.suggestedAccounts()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NetworkInsightsAnalysisId", NETWORK_INSIGHTS_ANALYSIS_ID_FIELD);
        map.put("NetworkInsightsAnalysisArn", NETWORK_INSIGHTS_ANALYSIS_ARN_FIELD);
        map.put("NetworkInsightsPathId", NETWORK_INSIGHTS_PATH_ID_FIELD);
        map.put("AdditionalAccountSet", ADDITIONAL_ACCOUNTS_FIELD);
        map.put("FilterInArnSet", FILTER_IN_ARNS_FIELD);
        map.put("FilterOutArnSet", FILTER_OUT_ARNS_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("WarningMessage", WARNING_MESSAGE_FIELD);
        map.put("NetworkPathFound", NETWORK_PATH_FOUND_FIELD);
        map.put("ForwardPathComponentSet", FORWARD_PATH_COMPONENTS_FIELD);
        map.put("ReturnPathComponentSet", RETURN_PATH_COMPONENTS_FIELD);
        map.put("ExplanationSet", EXPLANATIONS_FIELD);
        map.put("AlternatePathHintSet", ALTERNATE_PATH_HINTS_FIELD);
        map.put("SuggestedAccountSet", SUGGESTED_ACCOUNTS_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsAnalysis, T> g) {
        return obj -> g.apply((NetworkInsightsAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsAnalysisId;
        private String networkInsightsAnalysisArn;
        private String networkInsightsPathId;
        private List<String> additionalAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<String> filterInArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> filterOutArns = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private String status;
        private String statusMessage;
        private String warningMessage;
        private Boolean networkPathFound;
        private List<PathComponent> forwardPathComponents = DefaultSdkAutoConstructList.getInstance();
        private List<PathComponent> returnPathComponents = DefaultSdkAutoConstructList.getInstance();
        private List<Explanation> explanations = DefaultSdkAutoConstructList.getInstance();
        private List<AlternatePathHint> alternatePathHints = DefaultSdkAutoConstructList.getInstance();
        private List<String> suggestedAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsAnalysis model) {
            this.networkInsightsAnalysisId(model.networkInsightsAnalysisId);
            this.networkInsightsAnalysisArn(model.networkInsightsAnalysisArn);
            this.networkInsightsPathId(model.networkInsightsPathId);
            this.additionalAccounts(model.additionalAccounts);
            this.filterInArns(model.filterInArns);
            this.filterOutArns(model.filterOutArns);
            this.startDate(model.startDate);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.warningMessage(model.warningMessage);
            this.networkPathFound(model.networkPathFound);
            this.forwardPathComponents(model.forwardPathComponents);
            this.returnPathComponents(model.returnPathComponents);
            this.explanations(model.explanations);
            this.alternatePathHints(model.alternatePathHints);
            this.suggestedAccounts(model.suggestedAccounts);
            this.tags(model.tags);
        }

        public final String getNetworkInsightsAnalysisId() {
            return this.networkInsightsAnalysisId;
        }

        public final void setNetworkInsightsAnalysisId(String networkInsightsAnalysisId) {
            this.networkInsightsAnalysisId = networkInsightsAnalysisId;
        }

        @Override
        public final Builder networkInsightsAnalysisId(String networkInsightsAnalysisId) {
            this.networkInsightsAnalysisId = networkInsightsAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAnalysisArn() {
            return this.networkInsightsAnalysisArn;
        }

        public final void setNetworkInsightsAnalysisArn(String networkInsightsAnalysisArn) {
            this.networkInsightsAnalysisArn = networkInsightsAnalysisArn;
        }

        @Override
        public final Builder networkInsightsAnalysisArn(String networkInsightsAnalysisArn) {
            this.networkInsightsAnalysisArn = networkInsightsAnalysisArn;
            return this;
        }

        public final String getNetworkInsightsPathId() {
            return this.networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final Collection<String> getAdditionalAccounts() {
            if (this.additionalAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalAccounts;
        }

        public final void setAdditionalAccounts(Collection<String> additionalAccounts) {
            this.additionalAccounts = ValueStringListCopier.copy(additionalAccounts);
        }

        @Override
        public final Builder additionalAccounts(Collection<String> additionalAccounts) {
            this.additionalAccounts = ValueStringListCopier.copy(additionalAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAccounts(String ... additionalAccounts) {
            this.additionalAccounts(Arrays.asList(additionalAccounts));
            return this;
        }

        public final Collection<String> getFilterInArns() {
            if (this.filterInArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterInArns;
        }

        public final void setFilterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
        }

        @Override
        public final Builder filterInArns(Collection<String> filterInArns) {
            this.filterInArns = ArnListCopier.copy(filterInArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterInArns(String ... filterInArns) {
            this.filterInArns(Arrays.asList(filterInArns));
            return this;
        }

        public final Collection<String> getFilterOutArns() {
            if (this.filterOutArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterOutArns;
        }

        public final void setFilterOutArns(Collection<String> filterOutArns) {
            this.filterOutArns = ArnListCopier.copy(filterOutArns);
        }

        @Override
        public final Builder filterOutArns(Collection<String> filterOutArns) {
            this.filterOutArns = ArnListCopier.copy(filterOutArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOutArns(String ... filterOutArns) {
            this.filterOutArns(Arrays.asList(filterOutArns));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWarningMessage() {
            return this.warningMessage;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public final Boolean getNetworkPathFound() {
            return this.networkPathFound;
        }

        public final void setNetworkPathFound(Boolean networkPathFound) {
            this.networkPathFound = networkPathFound;
        }

        @Override
        public final Builder networkPathFound(Boolean networkPathFound) {
            this.networkPathFound = networkPathFound;
            return this;
        }

        public final List<PathComponent.Builder> getForwardPathComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.forwardPathComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForwardPathComponents(Collection<PathComponent.BuilderImpl> forwardPathComponents) {
            this.forwardPathComponents = PathComponentListCopier.copyFromBuilder(forwardPathComponents);
        }

        @Override
        public final Builder forwardPathComponents(Collection<PathComponent> forwardPathComponents) {
            this.forwardPathComponents = PathComponentListCopier.copy(forwardPathComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forwardPathComponents(PathComponent ... forwardPathComponents) {
            this.forwardPathComponents(Arrays.asList(forwardPathComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forwardPathComponents(Consumer<PathComponent.Builder> ... forwardPathComponents) {
            this.forwardPathComponents(Stream.of(forwardPathComponents).map(c -> (PathComponent)((PathComponent.Builder)PathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PathComponent.Builder> getReturnPathComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.returnPathComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnPathComponents(Collection<PathComponent.BuilderImpl> returnPathComponents) {
            this.returnPathComponents = PathComponentListCopier.copyFromBuilder(returnPathComponents);
        }

        @Override
        public final Builder returnPathComponents(Collection<PathComponent> returnPathComponents) {
            this.returnPathComponents = PathComponentListCopier.copy(returnPathComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnPathComponents(PathComponent ... returnPathComponents) {
            this.returnPathComponents(Arrays.asList(returnPathComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnPathComponents(Consumer<PathComponent.Builder> ... returnPathComponents) {
            this.returnPathComponents(Stream.of(returnPathComponents).map(c -> (PathComponent)((PathComponent.Builder)PathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Explanation.Builder> getExplanations() {
            List<Explanation.Builder> result = ExplanationListCopier.copyToBuilder(this.explanations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExplanations(Collection<Explanation.BuilderImpl> explanations) {
            this.explanations = ExplanationListCopier.copyFromBuilder(explanations);
        }

        @Override
        public final Builder explanations(Collection<Explanation> explanations) {
            this.explanations = ExplanationListCopier.copy(explanations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explanations(Explanation ... explanations) {
            this.explanations(Arrays.asList(explanations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder explanations(Consumer<Explanation.Builder> ... explanations) {
            this.explanations(Stream.of(explanations).map(c -> (Explanation)((Explanation.Builder)Explanation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AlternatePathHint.Builder> getAlternatePathHints() {
            List<AlternatePathHint.Builder> result = AlternatePathHintListCopier.copyToBuilder(this.alternatePathHints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternatePathHints(Collection<AlternatePathHint.BuilderImpl> alternatePathHints) {
            this.alternatePathHints = AlternatePathHintListCopier.copyFromBuilder(alternatePathHints);
        }

        @Override
        public final Builder alternatePathHints(Collection<AlternatePathHint> alternatePathHints) {
            this.alternatePathHints = AlternatePathHintListCopier.copy(alternatePathHints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatePathHints(AlternatePathHint ... alternatePathHints) {
            this.alternatePathHints(Arrays.asList(alternatePathHints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatePathHints(Consumer<AlternatePathHint.Builder> ... alternatePathHints) {
            this.alternatePathHints(Stream.of(alternatePathHints).map(c -> (AlternatePathHint)((AlternatePathHint.Builder)AlternatePathHint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSuggestedAccounts() {
            if (this.suggestedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.suggestedAccounts;
        }

        public final void setSuggestedAccounts(Collection<String> suggestedAccounts) {
            this.suggestedAccounts = ValueStringListCopier.copy(suggestedAccounts);
        }

        @Override
        public final Builder suggestedAccounts(Collection<String> suggestedAccounts) {
            this.suggestedAccounts = ValueStringListCopier.copy(suggestedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedAccounts(String ... suggestedAccounts) {
            this.suggestedAccounts(Arrays.asList(suggestedAccounts));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NetworkInsightsAnalysis build() {
            return new NetworkInsightsAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInsightsAnalysis> {
        public Builder networkInsightsAnalysisId(String var1);

        public Builder networkInsightsAnalysisArn(String var1);

        public Builder networkInsightsPathId(String var1);

        public Builder additionalAccounts(Collection<String> var1);

        public Builder additionalAccounts(String ... var1);

        public Builder filterInArns(Collection<String> var1);

        public Builder filterInArns(String ... var1);

        public Builder filterOutArns(Collection<String> var1);

        public Builder filterOutArns(String ... var1);

        public Builder startDate(Instant var1);

        public Builder status(String var1);

        public Builder status(AnalysisStatus var1);

        public Builder statusMessage(String var1);

        public Builder warningMessage(String var1);

        public Builder networkPathFound(Boolean var1);

        public Builder forwardPathComponents(Collection<PathComponent> var1);

        public Builder forwardPathComponents(PathComponent ... var1);

        public Builder forwardPathComponents(Consumer<PathComponent.Builder> ... var1);

        public Builder returnPathComponents(Collection<PathComponent> var1);

        public Builder returnPathComponents(PathComponent ... var1);

        public Builder returnPathComponents(Consumer<PathComponent.Builder> ... var1);

        public Builder explanations(Collection<Explanation> var1);

        public Builder explanations(Explanation ... var1);

        public Builder explanations(Consumer<Explanation.Builder> ... var1);

        public Builder alternatePathHints(Collection<AlternatePathHint> var1);

        public Builder alternatePathHints(AlternatePathHint ... var1);

        public Builder alternatePathHints(Consumer<AlternatePathHint.Builder> ... var1);

        public Builder suggestedAccounts(Collection<String> var1);

        public Builder suggestedAccounts(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

