/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.OutpostLag;
import software.amazon.awssdk.services.ec2.model.OutpostLagSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOutpostLagsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeOutpostLagsResponse> {
    private static final SdkField<List<OutpostLag>> OUTPOST_LAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutpostLags").getter(DescribeOutpostLagsResponse.getter(DescribeOutpostLagsResponse::outpostLags)).setter(DescribeOutpostLagsResponse.setter(Builder::outpostLags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagSet").unmarshallLocationName("outpostLagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutpostLag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOutpostLagsResponse.getter(DescribeOutpostLagsResponse::nextToken)).setter(DescribeOutpostLagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_LAGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOutpostLagsResponse.memberNameToFieldInitializer();
    private final List<OutpostLag> outpostLags;
    private final String nextToken;

    private DescribeOutpostLagsResponse(BuilderImpl builder) {
        super(builder);
        this.outpostLags = builder.outpostLags;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOutpostLags() {
        return this.outpostLags != null && !(this.outpostLags instanceof SdkAutoConstructList);
    }

    public final List<OutpostLag> outpostLags() {
        return this.outpostLags;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutpostLags() ? this.outpostLags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOutpostLagsResponse)) {
            return false;
        }
        DescribeOutpostLagsResponse other = (DescribeOutpostLagsResponse)((Object)obj);
        return this.hasOutpostLags() == other.hasOutpostLags() && Objects.equals(this.outpostLags(), other.outpostLags()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOutpostLagsResponse").add("OutpostLags", this.hasOutpostLags() ? this.outpostLags() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostLags": {
                return Optional.ofNullable(clazz.cast(this.outpostLags()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutpostLagSet", OUTPOST_LAGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOutpostLagsResponse, T> g) {
        return obj -> g.apply((DescribeOutpostLagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<OutpostLag> outpostLags = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOutpostLagsResponse model) {
            super(model);
            this.outpostLags(model.outpostLags);
            this.nextToken(model.nextToken);
        }

        public final List<OutpostLag.Builder> getOutpostLags() {
            List<OutpostLag.Builder> result = OutpostLagSetCopier.copyToBuilder(this.outpostLags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutpostLags(Collection<OutpostLag.BuilderImpl> outpostLags) {
            this.outpostLags = OutpostLagSetCopier.copyFromBuilder(outpostLags);
        }

        @Override
        public final Builder outpostLags(Collection<OutpostLag> outpostLags) {
            this.outpostLags = OutpostLagSetCopier.copy(outpostLags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostLags(OutpostLag ... outpostLags) {
            this.outpostLags(Arrays.asList(outpostLags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outpostLags(Consumer<OutpostLag.Builder> ... outpostLags) {
            this.outpostLags(Stream.of(outpostLags).map(c -> (OutpostLag)((OutpostLag.Builder)OutpostLag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOutpostLagsResponse build() {
            return new DescribeOutpostLagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOutpostLagsResponse> {
        public Builder outpostLags(Collection<OutpostLag> var1);

        public Builder outpostLags(OutpostLag ... var1);

        public Builder outpostLags(Consumer<OutpostLag.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

