/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamAddressHistoryResponse;
import software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord;

public class GetIpamAddressHistoryPublisher
implements SdkPublisher<GetIpamAddressHistoryResponse> {
    private final Ec2AsyncClient client;
    private final GetIpamAddressHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetIpamAddressHistoryPublisher(Ec2AsyncClient client, GetIpamAddressHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetIpamAddressHistoryPublisher(Ec2AsyncClient client, GetIpamAddressHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetIpamAddressHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetIpamAddressHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpamAddressHistoryRecord> historyRecords() {
        Function<GetIpamAddressHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.historyRecords() != null) {
                return response.historyRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetIpamAddressHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetIpamAddressHistoryResponseFetcher
    implements AsyncPageFetcher<GetIpamAddressHistoryResponse> {
        private GetIpamAddressHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamAddressHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetIpamAddressHistoryResponse> nextPage(GetIpamAddressHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetIpamAddressHistoryPublisher.this.client.getIpamAddressHistory(GetIpamAddressHistoryPublisher.this.firstRequest);
            }
            return GetIpamAddressHistoryPublisher.this.client.getIpamAddressHistory((GetIpamAddressHistoryRequest)((Object)GetIpamAddressHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

