/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider;

public class DescribeVerifiedAccessTrustProvidersIterable
implements SdkIterable<DescribeVerifiedAccessTrustProvidersResponse> {
    private final Ec2Client client;
    private final DescribeVerifiedAccessTrustProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedAccessTrustProvidersIterable(Ec2Client client, DescribeVerifiedAccessTrustProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVerifiedAccessTrustProvidersResponseFetcher();
    }

    public Iterator<DescribeVerifiedAccessTrustProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedAccessTrustProvider> verifiedAccessTrustProviders() {
        Function<DescribeVerifiedAccessTrustProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessTrustProviders() != null) {
                return response.verifiedAccessTrustProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedAccessTrustProvidersResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedAccessTrustProvidersResponse> {
        private DescribeVerifiedAccessTrustProvidersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessTrustProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedAccessTrustProvidersResponse nextPage(DescribeVerifiedAccessTrustProvidersResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessTrustProvidersIterable.this.client.describeVerifiedAccessTrustProviders(DescribeVerifiedAccessTrustProvidersIterable.this.firstRequest);
            }
            return DescribeVerifiedAccessTrustProvidersIterable.this.client.describeVerifiedAccessTrustProviders((DescribeVerifiedAccessTrustProvidersRequest)((Object)DescribeVerifiedAccessTrustProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

