/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteServerRoute;
import software.amazon.awssdk.services.ec2.model.RouteServerRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRouteServerRoutingDatabaseResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetRouteServerRoutingDatabaseResponse> {
    private static final SdkField<Boolean> ARE_ROUTES_PERSISTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AreRoutesPersisted").getter(GetRouteServerRoutingDatabaseResponse.getter(GetRouteServerRoutingDatabaseResponse::areRoutesPersisted)).setter(GetRouteServerRoutingDatabaseResponse.setter(Builder::areRoutesPersisted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreRoutesPersisted").unmarshallLocationName("areRoutesPersisted").build()}).build();
    private static final SdkField<List<RouteServerRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(GetRouteServerRoutingDatabaseResponse.getter(GetRouteServerRoutingDatabaseResponse::routes)).setter(GetRouteServerRoutingDatabaseResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").unmarshallLocationName("routeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteServerRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetRouteServerRoutingDatabaseResponse.getter(GetRouteServerRoutingDatabaseResponse::nextToken)).setter(GetRouteServerRoutingDatabaseResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARE_ROUTES_PERSISTED_FIELD, ROUTES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRouteServerRoutingDatabaseResponse.memberNameToFieldInitializer();
    private final Boolean areRoutesPersisted;
    private final List<RouteServerRoute> routes;
    private final String nextToken;

    private GetRouteServerRoutingDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.areRoutesPersisted = builder.areRoutesPersisted;
        this.routes = builder.routes;
        this.nextToken = builder.nextToken;
    }

    public final Boolean areRoutesPersisted() {
        return this.areRoutesPersisted;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<RouteServerRoute> routes() {
        return this.routes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.areRoutesPersisted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteServerRoutingDatabaseResponse)) {
            return false;
        }
        GetRouteServerRoutingDatabaseResponse other = (GetRouteServerRoutingDatabaseResponse)((Object)obj);
        return Objects.equals(this.areRoutesPersisted(), other.areRoutesPersisted()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRouteServerRoutingDatabaseResponse").add("AreRoutesPersisted", (Object)this.areRoutesPersisted()).add("Routes", this.hasRoutes() ? this.routes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreRoutesPersisted": {
                return Optional.ofNullable(clazz.cast(this.areRoutesPersisted()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AreRoutesPersisted", ARE_ROUTES_PERSISTED_FIELD);
        map.put("RouteSet", ROUTES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRouteServerRoutingDatabaseResponse, T> g) {
        return obj -> g.apply((GetRouteServerRoutingDatabaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean areRoutesPersisted;
        private List<RouteServerRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteServerRoutingDatabaseResponse model) {
            super(model);
            this.areRoutesPersisted(model.areRoutesPersisted);
            this.routes(model.routes);
            this.nextToken(model.nextToken);
        }

        public final Boolean getAreRoutesPersisted() {
            return this.areRoutesPersisted;
        }

        public final void setAreRoutesPersisted(Boolean areRoutesPersisted) {
            this.areRoutesPersisted = areRoutesPersisted;
        }

        @Override
        public final Builder areRoutesPersisted(Boolean areRoutesPersisted) {
            this.areRoutesPersisted = areRoutesPersisted;
            return this;
        }

        public final List<RouteServerRoute.Builder> getRoutes() {
            List<RouteServerRoute.Builder> result = RouteServerRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteServerRoute.BuilderImpl> routes) {
            this.routes = RouteServerRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteServerRoute> routes) {
            this.routes = RouteServerRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteServerRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteServerRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (RouteServerRoute)((RouteServerRoute.Builder)RouteServerRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetRouteServerRoutingDatabaseResponse build() {
            return new GetRouteServerRoutingDatabaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRouteServerRoutingDatabaseResponse> {
        public Builder areRoutesPersisted(Boolean var1);

        public Builder routes(Collection<RouteServerRoute> var1);

        public Builder routes(RouteServerRoute ... var1);

        public Builder routes(Consumer<RouteServerRoute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

