/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.services.ec2.model.RouteTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouteTablesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeRouteTablesResponse> {
    private static final SdkField<List<RouteTable>> ROUTE_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeRouteTablesResponse.getter(DescribeRouteTablesResponse::routeTables)).setter(DescribeRouteTablesResponse.setter(Builder::routeTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableSet").unmarshallLocationName("routeTableSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeRouteTablesResponse.getter(DescribeRouteTablesResponse::nextToken)).setter(DescribeRouteTablesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RouteTable> routeTables;
    private final String nextToken;

    private DescribeRouteTablesResponse(BuilderImpl builder) {
        super(builder);
        this.routeTables = builder.routeTables;
        this.nextToken = builder.nextToken;
    }

    public List<RouteTable> routeTables() {
        return this.routeTables;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesResponse)) {
            return false;
        }
        DescribeRouteTablesResponse other = (DescribeRouteTablesResponse)((Object)obj);
        return Objects.equals(this.routeTables(), other.routeTables()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRouteTablesResponse").add("RouteTables", this.routeTables()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTables": {
                return Optional.ofNullable(clazz.cast(this.routeTables()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteTablesResponse, T> g) {
        return obj -> g.apply((DescribeRouteTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<RouteTable> routeTables = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesResponse model) {
            super(model);
            this.routeTables(model.routeTables);
            this.nextToken(model.nextToken);
        }

        public final Collection<RouteTable.Builder> getRouteTables() {
            return this.routeTables != null ? (Collection)this.routeTables.stream().map(RouteTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routeTables(Collection<RouteTable> routeTables) {
            this.routeTables = RouteTableListCopier.copy(routeTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTables(RouteTable ... routeTables) {
            this.routeTables(Arrays.asList(routeTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTables(Consumer<RouteTable.Builder> ... routeTables) {
            this.routeTables(Stream.of(routeTables).map(c -> (RouteTable)((RouteTable.Builder)RouteTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRouteTables(Collection<RouteTable.BuilderImpl> routeTables) {
            this.routeTables = RouteTableListCopier.copyFromBuilder(routeTables);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRouteTablesResponse build() {
            return new DescribeRouteTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouteTablesResponse> {
        public Builder routeTables(Collection<RouteTable> var1);

        public Builder routeTables(RouteTable ... var1);

        public Builder routeTables(Consumer<RouteTable.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

