/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateVpcCidrBlockResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateVpcCidrBlockResponse> {
    private static final SdkField<VpcIpv6CidrBlockAssociation> IPV6_CIDR_BLOCK_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AssociateVpcCidrBlockResponse.getter(AssociateVpcCidrBlockResponse::ipv6CidrBlockAssociation)).setter(AssociateVpcCidrBlockResponse.setter(Builder::ipv6CidrBlockAssociation)).constructor(VpcIpv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociation").unmarshallLocationName("ipv6CidrBlockAssociation").build()}).build();
    private static final SdkField<VpcCidrBlockAssociation> CIDR_BLOCK_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AssociateVpcCidrBlockResponse.getter(AssociateVpcCidrBlockResponse::cidrBlockAssociation)).setter(AssociateVpcCidrBlockResponse.setter(Builder::cidrBlockAssociation)).constructor(VpcCidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociation").unmarshallLocationName("cidrBlockAssociation").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociateVpcCidrBlockResponse.getter(AssociateVpcCidrBlockResponse::vpcId)).setter(AssociateVpcCidrBlockResponse.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPV6_CIDR_BLOCK_ASSOCIATION_FIELD, CIDR_BLOCK_ASSOCIATION_FIELD, VPC_ID_FIELD));
    private final VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;
    private final VpcCidrBlockAssociation cidrBlockAssociation;
    private final String vpcId;

    private AssociateVpcCidrBlockResponse(BuilderImpl builder) {
        super(builder);
        this.ipv6CidrBlockAssociation = builder.ipv6CidrBlockAssociation;
        this.cidrBlockAssociation = builder.cidrBlockAssociation;
        this.vpcId = builder.vpcId;
    }

    public VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation() {
        return this.ipv6CidrBlockAssociation;
    }

    public VpcCidrBlockAssociation cidrBlockAssociation() {
        return this.cidrBlockAssociation;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlockAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockResponse)) {
            return false;
        }
        AssociateVpcCidrBlockResponse other = (AssociateVpcCidrBlockResponse)((Object)obj);
        return Objects.equals(this.ipv6CidrBlockAssociation(), other.ipv6CidrBlockAssociation()) && Objects.equals(this.cidrBlockAssociation(), other.cidrBlockAssociation()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateVpcCidrBlockResponse").add("Ipv6CidrBlockAssociation", (Object)this.ipv6CidrBlockAssociation()).add("CidrBlockAssociation", (Object)this.cidrBlockAssociation()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6CidrBlockAssociation": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociation()));
            }
            case "CidrBlockAssociation": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockAssociation()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVpcCidrBlockResponse, T> g) {
        return obj -> g.apply((AssociateVpcCidrBlockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation;
        private VpcCidrBlockAssociation cidrBlockAssociation;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockResponse model) {
            super(model);
            this.ipv6CidrBlockAssociation(model.ipv6CidrBlockAssociation);
            this.cidrBlockAssociation(model.cidrBlockAssociation);
            this.vpcId(model.vpcId);
        }

        public final VpcIpv6CidrBlockAssociation.Builder getIpv6CidrBlockAssociation() {
            return this.ipv6CidrBlockAssociation != null ? this.ipv6CidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation;
            return this;
        }

        public final void setIpv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation.BuilderImpl ipv6CidrBlockAssociation) {
            this.ipv6CidrBlockAssociation = ipv6CidrBlockAssociation != null ? ipv6CidrBlockAssociation.build() : null;
        }

        public final VpcCidrBlockAssociation.Builder getCidrBlockAssociation() {
            return this.cidrBlockAssociation != null ? this.cidrBlockAssociation.toBuilder() : null;
        }

        @Override
        public final Builder cidrBlockAssociation(VpcCidrBlockAssociation cidrBlockAssociation) {
            this.cidrBlockAssociation = cidrBlockAssociation;
            return this;
        }

        public final void setCidrBlockAssociation(VpcCidrBlockAssociation.BuilderImpl cidrBlockAssociation) {
            this.cidrBlockAssociation = cidrBlockAssociation != null ? cidrBlockAssociation.build() : null;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public AssociateVpcCidrBlockResponse build() {
            return new AssociateVpcCidrBlockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateVpcCidrBlockResponse> {
        public Builder ipv6CidrBlockAssociation(VpcIpv6CidrBlockAssociation var1);

        default public Builder ipv6CidrBlockAssociation(Consumer<VpcIpv6CidrBlockAssociation.Builder> ipv6CidrBlockAssociation) {
            return this.ipv6CidrBlockAssociation((VpcIpv6CidrBlockAssociation)((VpcIpv6CidrBlockAssociation.Builder)VpcIpv6CidrBlockAssociation.builder().applyMutation(ipv6CidrBlockAssociation)).build());
        }

        public Builder cidrBlockAssociation(VpcCidrBlockAssociation var1);

        default public Builder cidrBlockAssociation(Consumer<VpcCidrBlockAssociation.Builder> cidrBlockAssociation) {
            return this.cidrBlockAssociation((VpcCidrBlockAssociation)((VpcCidrBlockAssociation.Builder)VpcCidrBlockAssociation.builder().applyMutation(cidrBlockAssociation)).build());
        }

        public Builder vpcId(String var1);
    }
}

