/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AuthorizationRule;
import software.amazon.awssdk.services.ec2.model.AuthorizationRuleSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientVpnAuthorizationRulesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeClientVpnAuthorizationRulesResponse> {
    private static final SdkField<List<AuthorizationRule>> AUTHORIZATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizationRules").getter(DescribeClientVpnAuthorizationRulesResponse.getter(DescribeClientVpnAuthorizationRulesResponse::authorizationRules)).setter(DescribeClientVpnAuthorizationRulesResponse.setter(Builder::authorizationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationRule").unmarshallLocationName("authorizationRule").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientVpnAuthorizationRulesResponse.getter(DescribeClientVpnAuthorizationRulesResponse::nextToken)).setter(DescribeClientVpnAuthorizationRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_RULES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AuthorizationRule", AUTHORIZATION_RULES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AuthorizationRule> authorizationRules;
    private final String nextToken;

    private DescribeClientVpnAuthorizationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationRules = builder.authorizationRules;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthorizationRules() {
        return this.authorizationRules != null && !(this.authorizationRules instanceof SdkAutoConstructList);
    }

    public final List<AuthorizationRule> authorizationRules() {
        return this.authorizationRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizationRules() ? this.authorizationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnAuthorizationRulesResponse)) {
            return false;
        }
        DescribeClientVpnAuthorizationRulesResponse other = (DescribeClientVpnAuthorizationRulesResponse)((Object)obj);
        return this.hasAuthorizationRules() == other.hasAuthorizationRules() && Objects.equals(this.authorizationRules(), other.authorizationRules()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientVpnAuthorizationRulesResponse").add("AuthorizationRules", this.hasAuthorizationRules() ? this.authorizationRules() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationRules": {
                return Optional.ofNullable(clazz.cast(this.authorizationRules()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnAuthorizationRulesResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnAuthorizationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<AuthorizationRule> authorizationRules = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnAuthorizationRulesResponse model) {
            super(model);
            this.authorizationRules(model.authorizationRules);
            this.nextToken(model.nextToken);
        }

        public final List<AuthorizationRule.Builder> getAuthorizationRules() {
            List<AuthorizationRule.Builder> result = AuthorizationRuleSetCopier.copyToBuilder(this.authorizationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizationRules(Collection<AuthorizationRule.BuilderImpl> authorizationRules) {
            this.authorizationRules = AuthorizationRuleSetCopier.copyFromBuilder(authorizationRules);
        }

        @Override
        public final Builder authorizationRules(Collection<AuthorizationRule> authorizationRules) {
            this.authorizationRules = AuthorizationRuleSetCopier.copy(authorizationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationRules(AuthorizationRule ... authorizationRules) {
            this.authorizationRules(Arrays.asList(authorizationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationRules(Consumer<AuthorizationRule.Builder> ... authorizationRules) {
            this.authorizationRules(Stream.of(authorizationRules).map(c -> (AuthorizationRule)((AuthorizationRule.Builder)AuthorizationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientVpnAuthorizationRulesResponse build() {
            return new DescribeClientVpnAuthorizationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientVpnAuthorizationRulesResponse> {
        public Builder authorizationRules(Collection<AuthorizationRule> var1);

        public Builder authorizationRules(AuthorizationRule ... var1);

        public Builder authorizationRules(Consumer<AuthorizationRule.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

