/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ReservationValue;
import software.amazon.awssdk.services.ec2.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetReservationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetReservationValue> {
    private static final SdkField<ReservationValue> RESERVATION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReservationValue").getter(TargetReservationValue.getter(TargetReservationValue::reservationValue)).setter(TargetReservationValue.setter(Builder::reservationValue)).constructor(ReservationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationValue").unmarshallLocationName("reservationValue").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(TargetReservationValue.getter(TargetReservationValue::targetConfiguration)).setter(TargetReservationValue.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").unmarshallLocationName("targetConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_VALUE_FIELD, TARGET_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetReservationValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ReservationValue reservationValue;
    private final TargetConfiguration targetConfiguration;

    private TargetReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.targetConfiguration = builder.targetConfiguration;
    }

    public final ReservationValue reservationValue() {
        return this.reservationValue;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetReservationValue)) {
            return false;
        }
        TargetReservationValue other = (TargetReservationValue)obj;
        return Objects.equals(this.reservationValue(), other.reservationValue()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TargetReservationValue").add("ReservationValue", (Object)this.reservationValue()).add("TargetConfiguration", (Object)this.targetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservationValue": {
                return Optional.ofNullable(clazz.cast(this.reservationValue()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservationValue", RESERVATION_VALUE_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetReservationValue, T> g) {
        return obj -> g.apply((TargetReservationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ReservationValue reservationValue;
        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetReservationValue model) {
            this.reservationValue(model.reservationValue);
            this.targetConfiguration(model.targetConfiguration);
        }

        public final ReservationValue.Builder getReservationValue() {
            return this.reservationValue != null ? this.reservationValue.toBuilder() : null;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public TargetReservationValue build() {
            return new TargetReservationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetReservationValue> {
        public Builder reservationValue(ReservationValue var1);

        default public Builder reservationValue(Consumer<ReservationValue.Builder> reservationValue) {
            return this.reservationValue((ReservationValue)((ReservationValue.Builder)ReservationValue.builder().applyMutation(reservationValue)).build());
        }

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }
    }
}

