/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment;

public class DescribeTransitGatewayPeeringAttachmentsPublisher
implements SdkPublisher<DescribeTransitGatewayPeeringAttachmentsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeTransitGatewayPeeringAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTransitGatewayPeeringAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayPeeringAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTransitGatewayPeeringAttachmentsPublisher(Ec2AsyncClient client, DescribeTransitGatewayPeeringAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTransitGatewayPeeringAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTransitGatewayPeeringAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments() {
        Function<DescribeTransitGatewayPeeringAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayPeeringAttachments() != null) {
                return response.transitGatewayPeeringAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTransitGatewayPeeringAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTransitGatewayPeeringAttachmentsResponseFetcher
    implements AsyncPageFetcher<DescribeTransitGatewayPeeringAttachmentsResponse> {
        private DescribeTransitGatewayPeeringAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayPeeringAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTransitGatewayPeeringAttachmentsResponse> nextPage(DescribeTransitGatewayPeeringAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayPeeringAttachmentsPublisher.this.client.describeTransitGatewayPeeringAttachments(DescribeTransitGatewayPeeringAttachmentsPublisher.this.firstRequest);
            }
            return DescribeTransitGatewayPeeringAttachmentsPublisher.this.client.describeTransitGatewayPeeringAttachments((DescribeTransitGatewayPeeringAttachmentsRequest)((Object)DescribeTransitGatewayPeeringAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

