/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateAddressResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AllocateAddressResponse> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(AllocateAddressResponse.getter(AllocateAddressResponse::allocationId)).setter(AllocateAddressResponse.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpv4Pool").getter(AllocateAddressResponse.getter(AllocateAddressResponse::publicIpv4Pool)).setter(AllocateAddressResponse.setter(Builder::publicIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").unmarshallLocationName("publicIpv4Pool").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(AllocateAddressResponse.getter(AllocateAddressResponse::networkBorderGroup)).setter(AllocateAddressResponse.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(AllocateAddressResponse.getter(AllocateAddressResponse::domainAsString)).setter(AllocateAddressResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("domain").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIp").getter(AllocateAddressResponse.getter(AllocateAddressResponse::customerOwnedIp)).setter(AllocateAddressResponse.setter(Builder::customerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp").unmarshallLocationName("customerOwnedIp").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(AllocateAddressResponse.getter(AllocateAddressResponse::customerOwnedIpv4Pool)).setter(AllocateAddressResponse.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("customerOwnedIpv4Pool").build()}).build();
    private static final SdkField<String> CARRIER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CarrierIp").getter(AllocateAddressResponse.getter(AllocateAddressResponse::carrierIp)).setter(AllocateAddressResponse.setter(Builder::carrierIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp").unmarshallLocationName("carrierIp").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(AllocateAddressResponse.getter(AllocateAddressResponse::publicIp)).setter(AllocateAddressResponse.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD, PUBLIC_IPV4_POOL_FIELD, NETWORK_BORDER_GROUP_FIELD, DOMAIN_FIELD, CUSTOMER_OWNED_IP_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, CARRIER_IP_FIELD, PUBLIC_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AllocationId", ALLOCATION_ID_FIELD);
            this.put("PublicIpv4Pool", PUBLIC_IPV4_POOL_FIELD);
            this.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
            this.put("Domain", DOMAIN_FIELD);
            this.put("CustomerOwnedIp", CUSTOMER_OWNED_IP_FIELD);
            this.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
            this.put("CarrierIp", CARRIER_IP_FIELD);
            this.put("PublicIp", PUBLIC_IP_FIELD);
        }
    });
    private final String allocationId;
    private final String publicIpv4Pool;
    private final String networkBorderGroup;
    private final String domain;
    private final String customerOwnedIp;
    private final String customerOwnedIpv4Pool;
    private final String carrierIp;
    private final String publicIp;

    private AllocateAddressResponse(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.domain = builder.domain;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.carrierIp = builder.carrierIp;
        this.publicIp = builder.publicIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String publicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final String customerOwnedIp() {
        return this.customerOwnedIp;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final String carrierIp() {
        return this.carrierIp;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrierIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressResponse)) {
            return false;
        }
        AllocateAddressResponse other = (AllocateAddressResponse)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.publicIpv4Pool(), other.publicIpv4Pool()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.customerOwnedIp(), other.customerOwnedIp()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.carrierIp(), other.carrierIp()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateAddressResponse").add("AllocationId", (Object)this.allocationId()).add("PublicIpv4Pool", (Object)this.publicIpv4Pool()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("Domain", (Object)this.domainAsString()).add("CustomerOwnedIp", (Object)this.customerOwnedIp()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("CarrierIp", (Object)this.carrierIp()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "PublicIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pool()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "CustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIp()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "CarrierIp": {
                return Optional.ofNullable(clazz.cast(this.carrierIp()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AllocateAddressResponse, T> g) {
        return obj -> g.apply((AllocateAddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String allocationId;
        private String publicIpv4Pool;
        private String networkBorderGroup;
        private String domain;
        private String customerOwnedIp;
        private String customerOwnedIpv4Pool;
        private String carrierIp;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressResponse model) {
            super(model);
            this.allocationId(model.allocationId);
            this.publicIpv4Pool(model.publicIpv4Pool);
            this.networkBorderGroup(model.networkBorderGroup);
            this.domain(model.domain);
            this.customerOwnedIp(model.customerOwnedIp);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.carrierIp(model.carrierIp);
            this.publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final String getCustomerOwnedIp() {
            return this.customerOwnedIp;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        @Override
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final String getCarrierIp() {
            return this.carrierIp;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        @Override
        public AllocateAddressResponse build() {
            return new AllocateAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateAddressResponse> {
        public Builder allocationId(String var1);

        public Builder publicIpv4Pool(String var1);

        public Builder networkBorderGroup(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder customerOwnedIp(String var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder carrierIp(String var1);

        public Builder publicIp(String var1);
    }
}

