/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceEventWindowStateChange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceEventWindowStateChange> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(InstanceEventWindowStateChange.getter(InstanceEventWindowStateChange::instanceEventWindowId)).setter(InstanceEventWindowStateChange.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("instanceEventWindowId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(InstanceEventWindowStateChange.getter(InstanceEventWindowStateChange::stateAsString)).setter(InstanceEventWindowStateChange.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOW_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceEventWindowId", INSTANCE_EVENT_WINDOW_ID_FIELD);
            this.put("State", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String instanceEventWindowId;
    private final String state;

    private InstanceEventWindowStateChange(BuilderImpl builder) {
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.state = builder.state;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    public final InstanceEventWindowState state() {
        return InstanceEventWindowState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindowStateChange)) {
            return false;
        }
        InstanceEventWindowStateChange other = (InstanceEventWindowStateChange)obj;
        return Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceEventWindowStateChange").add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindowStateChange, T> g) {
        return obj -> g.apply((InstanceEventWindowStateChange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceEventWindowId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindowStateChange model) {
            this.instanceEventWindowId(model.instanceEventWindowId);
            this.state(model.state);
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceEventWindowState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public InstanceEventWindowStateChange build() {
            return new InstanceEventWindowStateChange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceEventWindowStateChange> {
        public Builder instanceEventWindowId(String var1);

        public Builder state(String var1);

        public Builder state(InstanceEventWindowState var1);
    }
}

