/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
    private static final SdkField<List<VerifiedAccessInstanceLoggingConfiguration>> LOGGING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoggingConfigurations").getter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.getter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse::loggingConfigurations)).setter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.setter(Builder::loggingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfigurationSet").unmarshallLocationName("loggingConfigurationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessInstanceLoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.getter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse::nextToken)).setter(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LoggingConfigurationSet", LOGGING_CONFIGURATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations;
    private final String nextToken;

    private DescribeVerifiedAccessInstanceLoggingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.loggingConfigurations = builder.loggingConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLoggingConfigurations() {
        return this.loggingConfigurations != null && !(this.loggingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations() {
        return this.loggingConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoggingConfigurations() ? this.loggingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessInstanceLoggingConfigurationsResponse)) {
            return false;
        }
        DescribeVerifiedAccessInstanceLoggingConfigurationsResponse other = (DescribeVerifiedAccessInstanceLoggingConfigurationsResponse)((Object)obj);
        return this.hasLoggingConfigurations() == other.hasLoggingConfigurations() && Objects.equals(this.loggingConfigurations(), other.loggingConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedAccessInstanceLoggingConfigurationsResponse").add("LoggingConfigurations", this.hasLoggingConfigurations() ? this.loggingConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoggingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.loggingConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessInstanceLoggingConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessInstanceLoggingConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessInstanceLoggingConfigurationsResponse model) {
            super(model);
            this.loggingConfigurations(model.loggingConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<VerifiedAccessInstanceLoggingConfiguration.Builder> getLoggingConfigurations() {
            List<VerifiedAccessInstanceLoggingConfiguration.Builder> result = VerifiedAccessInstanceLoggingConfigurationListCopier.copyToBuilder(this.loggingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoggingConfigurations(Collection<VerifiedAccessInstanceLoggingConfiguration.BuilderImpl> loggingConfigurations) {
            this.loggingConfigurations = VerifiedAccessInstanceLoggingConfigurationListCopier.copyFromBuilder(loggingConfigurations);
        }

        @Override
        public final Builder loggingConfigurations(Collection<VerifiedAccessInstanceLoggingConfiguration> loggingConfigurations) {
            this.loggingConfigurations = VerifiedAccessInstanceLoggingConfigurationListCopier.copy(loggingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(VerifiedAccessInstanceLoggingConfiguration ... loggingConfigurations) {
            this.loggingConfigurations(Arrays.asList(loggingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggingConfigurations(Consumer<VerifiedAccessInstanceLoggingConfiguration.Builder> ... loggingConfigurations) {
            this.loggingConfigurations(Stream.of(loggingConfigurations).map(c -> (VerifiedAccessInstanceLoggingConfiguration)((VerifiedAccessInstanceLoggingConfiguration.Builder)VerifiedAccessInstanceLoggingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedAccessInstanceLoggingConfigurationsResponse build() {
            return new DescribeVerifiedAccessInstanceLoggingConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedAccessInstanceLoggingConfigurationsResponse> {
        public Builder loggingConfigurations(Collection<VerifiedAccessInstanceLoggingConfiguration> var1);

        public Builder loggingConfigurations(VerifiedAccessInstanceLoggingConfiguration ... var1);

        public Builder loggingConfigurations(Consumer<VerifiedAccessInstanceLoggingConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

