/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate;
import software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySecurityGroupRulesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifySecurityGroupRulesRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(ModifySecurityGroupRulesRequest.getter(ModifySecurityGroupRulesRequest::groupId)).setter(ModifySecurityGroupRulesRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build()}).build();
    private static final SdkField<List<SecurityGroupRuleUpdate>> SECURITY_GROUP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupRules").getter(ModifySecurityGroupRulesRequest.getter(ModifySecurityGroupRulesRequest::securityGroupRules)).setter(ModifySecurityGroupRulesRequest.setter(Builder::securityGroupRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRule").unmarshallLocationName("SecurityGroupRule").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupRuleUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifySecurityGroupRulesRequest.getter(ModifySecurityGroupRulesRequest::dryRun)).setter(ModifySecurityGroupRulesRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, SECURITY_GROUP_RULES_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupId", GROUP_ID_FIELD);
            this.put("SecurityGroupRule", SECURITY_GROUP_RULES_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String groupId;
    private final List<SecurityGroupRuleUpdate> securityGroupRules;
    private final Boolean dryRun;

    private ModifySecurityGroupRulesRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.securityGroupRules = builder.securityGroupRules;
        this.dryRun = builder.dryRun;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasSecurityGroupRules() {
        return this.securityGroupRules != null && !(this.securityGroupRules instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupRuleUpdate> securityGroupRules() {
        return this.securityGroupRules;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupRules() ? this.securityGroupRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySecurityGroupRulesRequest)) {
            return false;
        }
        ModifySecurityGroupRulesRequest other = (ModifySecurityGroupRulesRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && this.hasSecurityGroupRules() == other.hasSecurityGroupRules() && Objects.equals(this.securityGroupRules(), other.securityGroupRules()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySecurityGroupRulesRequest").add("GroupId", (Object)this.groupId()).add("SecurityGroupRules", this.hasSecurityGroupRules() ? this.securityGroupRules() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "SecurityGroupRules": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRules()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifySecurityGroupRulesRequest, T> g) {
        return obj -> g.apply((ModifySecurityGroupRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String groupId;
        private List<SecurityGroupRuleUpdate> securityGroupRules = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySecurityGroupRulesRequest model) {
            super(model);
            this.groupId(model.groupId);
            this.securityGroupRules(model.securityGroupRules);
            this.dryRun(model.dryRun);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<SecurityGroupRuleUpdate.Builder> getSecurityGroupRules() {
            List<SecurityGroupRuleUpdate.Builder> result = SecurityGroupRuleUpdateListCopier.copyToBuilder(this.securityGroupRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRules(Collection<SecurityGroupRuleUpdate.BuilderImpl> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleUpdateListCopier.copyFromBuilder(securityGroupRules);
        }

        @Override
        public final Builder securityGroupRules(Collection<SecurityGroupRuleUpdate> securityGroupRules) {
            this.securityGroupRules = SecurityGroupRuleUpdateListCopier.copy(securityGroupRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(SecurityGroupRuleUpdate ... securityGroupRules) {
            this.securityGroupRules(Arrays.asList(securityGroupRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRules(Consumer<SecurityGroupRuleUpdate.Builder> ... securityGroupRules) {
            this.securityGroupRules(Stream.of(securityGroupRules).map(c -> (SecurityGroupRuleUpdate)((SecurityGroupRuleUpdate.Builder)SecurityGroupRuleUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySecurityGroupRulesRequest build() {
            return new ModifySecurityGroupRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySecurityGroupRulesRequest> {
        public Builder groupId(String var1);

        public Builder securityGroupRules(Collection<SecurityGroupRuleUpdate> var1);

        public Builder securityGroupRules(SecurityGroupRuleUpdate ... var1);

        public Builder securityGroupRules(Consumer<SecurityGroupRuleUpdate.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

