/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelImportTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CancelImportTaskRequest> {
    private static final SdkField<String> CANCEL_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CancelReason").getter(CancelImportTaskRequest.getter(CancelImportTaskRequest::cancelReason)).setter(CancelImportTaskRequest.setter(Builder::cancelReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelReason").unmarshallLocationName("CancelReason").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CancelImportTaskRequest.getter(CancelImportTaskRequest::dryRun)).setter(CancelImportTaskRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportTaskId").getter(CancelImportTaskRequest.getter(CancelImportTaskRequest::importTaskId)).setter(CancelImportTaskRequest.setter(Builder::importTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTaskId").unmarshallLocationName("ImportTaskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_REASON_FIELD, DRY_RUN_FIELD, IMPORT_TASK_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CancelReason", CANCEL_REASON_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("ImportTaskId", IMPORT_TASK_ID_FIELD);
        }
    });
    private final String cancelReason;
    private final Boolean dryRun;
    private final String importTaskId;

    private CancelImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cancelReason = builder.cancelReason;
        this.dryRun = builder.dryRun;
        this.importTaskId = builder.importTaskId;
    }

    public final String cancelReason() {
        return this.cancelReason;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String importTaskId() {
        return this.importTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskRequest)) {
            return false;
        }
        CancelImportTaskRequest other = (CancelImportTaskRequest)((Object)obj);
        return Objects.equals(this.cancelReason(), other.cancelReason()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.importTaskId(), other.importTaskId());
    }

    public final String toString() {
        return ToString.builder((String)"CancelImportTaskRequest").add("CancelReason", (Object)this.cancelReason()).add("DryRun", (Object)this.dryRun()).add("ImportTaskId", (Object)this.importTaskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CancelReason": {
                return Optional.ofNullable(clazz.cast(this.cancelReason()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ImportTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelImportTaskRequest, T> g) {
        return obj -> g.apply((CancelImportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String cancelReason;
        private Boolean dryRun;
        private String importTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskRequest model) {
            super(model);
            this.cancelReason(model.cancelReason);
            this.dryRun(model.dryRun);
            this.importTaskId(model.importTaskId);
        }

        public final String getCancelReason() {
            return this.cancelReason;
        }

        public final void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        @Override
        public final Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelImportTaskRequest build() {
            return new CancelImportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelImportTaskRequest> {
        public Builder cancelReason(String var1);

        public Builder dryRun(Boolean var1);

        public Builder importTaskId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

