/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PerformanceFactorReferenceRequest;
import software.amazon.awssdk.services.ec2.model.PerformanceFactorReferenceSetRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CpuPerformanceFactorRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CpuPerformanceFactorRequest> {
    private static final SdkField<List<PerformanceFactorReferenceRequest>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("References").getter(CpuPerformanceFactorRequest.getter(CpuPerformanceFactorRequest::references)).setter(CpuPerformanceFactorRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reference").unmarshallLocationName("Reference").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PerformanceFactorReferenceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Reference", REFERENCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<PerformanceFactorReferenceRequest> references;

    private CpuPerformanceFactorRequest(BuilderImpl builder) {
        this.references = builder.references;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructList);
    }

    public final List<PerformanceFactorReferenceRequest> references() {
        return this.references;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuPerformanceFactorRequest)) {
            return false;
        }
        CpuPerformanceFactorRequest other = (CpuPerformanceFactorRequest)obj;
        return this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references());
    }

    public final String toString() {
        return ToString.builder((String)"CpuPerformanceFactorRequest").add("References", this.hasReferences() ? this.references() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CpuPerformanceFactorRequest, T> g) {
        return obj -> g.apply((CpuPerformanceFactorRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PerformanceFactorReferenceRequest> references = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CpuPerformanceFactorRequest model) {
            this.references(model.references);
        }

        public final List<PerformanceFactorReferenceRequest.Builder> getReferences() {
            List<PerformanceFactorReferenceRequest.Builder> result = PerformanceFactorReferenceSetRequestCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<PerformanceFactorReferenceRequest.BuilderImpl> references) {
            this.references = PerformanceFactorReferenceSetRequestCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<PerformanceFactorReferenceRequest> references) {
            this.references = PerformanceFactorReferenceSetRequestCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(PerformanceFactorReferenceRequest ... references) {
            this.references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<PerformanceFactorReferenceRequest.Builder> ... references) {
            this.references(Stream.of(references).map(c -> (PerformanceFactorReferenceRequest)((PerformanceFactorReferenceRequest.Builder)PerformanceFactorReferenceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CpuPerformanceFactorRequest build() {
            return new CpuPerformanceFactorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CpuPerformanceFactorRequest> {
        public Builder references(Collection<PerformanceFactorReferenceRequest> var1);

        public Builder references(PerformanceFactorReferenceRequest ... var1);

        public Builder references(Consumer<PerformanceFactorReferenceRequest.Builder> ... var1);
    }
}

