/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcClassicLinkDnsSupportRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
    private static final SdkField<List<String>> VPC_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcIds").getter(DescribeVpcClassicLinkDnsSupportRequest.getter(DescribeVpcClassicLinkDnsSupportRequest::vpcIds)).setter(DescribeVpcClassicLinkDnsSupportRequest.setter(Builder::vpcIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIds").unmarshallLocationName("VpcIds").build(), ListTrait.builder().memberLocationName("VpcId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeVpcClassicLinkDnsSupportRequest.getter(DescribeVpcClassicLinkDnsSupportRequest::maxResults)).setter(DescribeVpcClassicLinkDnsSupportRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcClassicLinkDnsSupportRequest.getter(DescribeVpcClassicLinkDnsSupportRequest::nextToken)).setter(DescribeVpcClassicLinkDnsSupportRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> vpcIds;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeVpcClassicLinkDnsSupportRequest(BuilderImpl builder) {
        super(builder);
        this.vpcIds = builder.vpcIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcIds() {
        return this.vpcIds != null && !(this.vpcIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcIds() {
        return this.vpcIds;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcIds() ? this.vpcIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportRequest)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportRequest other = (DescribeVpcClassicLinkDnsSupportRequest)((Object)obj);
        return this.hasVpcIds() == other.hasVpcIds() && Objects.equals(this.vpcIds(), other.vpcIds()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcClassicLinkDnsSupportRequest").add("VpcIds", this.hasVpcIds() ? this.vpcIds() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcIds": {
                return Optional.ofNullable(clazz.cast(this.vpcIds()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkDnsSupportRequest, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkDnsSupportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> vpcIds = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportRequest model) {
            super(model);
            this.vpcIds(model.vpcIds);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getVpcIds() {
            if (this.vpcIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcIds;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpcClassicLinkDnsSupportRequest build() {
            return new DescribeVpcClassicLinkDnsSupportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
        public Builder vpcIds(Collection<String> var1);

        public Builder vpcIds(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

