/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityGroupRuleDescriptionsIngressRequest extends Ec2Request
        implements
        ToCopyableBuilder<UpdateSecurityGroupRuleDescriptionsIngressRequest.Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("GroupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("GroupName").build()).build();

    private static final SdkField<List<IpPermission>> IP_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("IpPermissions")
            .getter(getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::ipPermissions))
            .setter(setter(Builder::ipPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions")
                    .unmarshallLocationName("IpPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<SecurityGroupRuleDescription>> SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD = SdkField
            .<List<SecurityGroupRuleDescription>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupRuleDescriptions")
            .getter(getter(UpdateSecurityGroupRuleDescriptionsIngressRequest::securityGroupRuleDescriptions))
            .setter(setter(Builder::securityGroupRuleDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleDescription")
                    .unmarshallLocationName("SecurityGroupRuleDescription").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupRuleDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupRuleDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, GROUP_ID_FIELD,
            GROUP_NAME_FIELD, IP_PERMISSIONS_FIELD, SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("GroupId", GROUP_ID_FIELD);
                    put("GroupName", GROUP_NAME_FIELD);
                    put("IpPermissions", IP_PERMISSIONS_FIELD);
                    put("SecurityGroupRuleDescription", SECURITY_GROUP_RULE_DESCRIPTIONS_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String groupId;

    private final String groupName;

    private final List<IpPermission> ipPermissions;

    private final List<SecurityGroupRuleDescription> securityGroupRuleDescriptions;

    private UpdateSecurityGroupRuleDescriptionsIngressRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.securityGroupRuleDescriptions = builder.securityGroupRuleDescriptions;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the security group. You must specify either the security group ID or the security group name in the
     * request. For security groups in a nondefault VPC, you must specify the security group ID.
     * </p>
     * 
     * @return The ID of the security group. You must specify either the security group ID or the security group name in
     *         the request. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * [Default VPC] The name of the security group. You must specify either the security group ID or the security group
     * name. For security groups in a nondefault VPC, you must specify the security group ID.
     * </p>
     * 
     * @return [Default VPC] The name of the security group. You must specify either the security group ID or the
     *         security group name. For security groups in a nondefault VPC, you must specify the security group ID.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpPermissions() {
        return ipPermissions != null && !(ipPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP permissions for the security group rule. You must specify either IP permissions or a description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPermissions} method.
     * </p>
     * 
     * @return The IP permissions for the security group rule. You must specify either IP permissions or a description.
     */
    public final List<IpPermission> ipPermissions() {
        return ipPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupRuleDescriptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityGroupRuleDescriptions() {
        return securityGroupRuleDescriptions != null && !(securityGroupRuleDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The description for the ingress security group rules. You must specify either a description or IP permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupRuleDescriptions} method.
     * </p>
     * 
     * @return The description for the ingress security group rules. You must specify either a description or IP
     *         permissions.
     */
    public final List<SecurityGroupRuleDescription> securityGroupRuleDescriptions() {
        return securityGroupRuleDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPermissions() ? ipPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupRuleDescriptions() ? securityGroupRuleDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsIngressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsIngressRequest other = (UpdateSecurityGroupRuleDescriptionsIngressRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(groupName(), other.groupName()) && hasIpPermissions() == other.hasIpPermissions()
                && Objects.equals(ipPermissions(), other.ipPermissions())
                && hasSecurityGroupRuleDescriptions() == other.hasSecurityGroupRuleDescriptions()
                && Objects.equals(securityGroupRuleDescriptions(), other.securityGroupRuleDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateSecurityGroupRuleDescriptionsIngressRequest")
                .add("DryRun", dryRun())
                .add("GroupId", groupId())
                .add("GroupName", groupName())
                .add("IpPermissions", hasIpPermissions() ? ipPermissions() : null)
                .add("SecurityGroupRuleDescriptions", hasSecurityGroupRuleDescriptions() ? securityGroupRuleDescriptions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "IpPermissions":
            return Optional.ofNullable(clazz.cast(ipPermissions()));
        case "SecurityGroupRuleDescriptions":
            return Optional.ofNullable(clazz.cast(securityGroupRuleDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityGroupRuleDescriptionsIngressRequest, T> g) {
        return obj -> g.apply((UpdateSecurityGroupRuleDescriptionsIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityGroupRuleDescriptionsIngressRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the security group. You must specify either the security group ID or the security group name in the
         * request. For security groups in a nondefault VPC, you must specify the security group ID.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group. You must specify either the security group ID or the security group name
         *        in the request. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * [Default VPC] The name of the security group. You must specify either the security group ID or the security
         * group name. For security groups in a nondefault VPC, you must specify the security group ID.
         * </p>
         * 
         * @param groupName
         *        [Default VPC] The name of the security group. You must specify either the security group ID or the
         *        security group name. For security groups in a nondefault VPC, you must specify the security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The IP permissions for the security group rule. You must specify either IP permissions or a description.
         * </p>
         * 
         * @param ipPermissions
         *        The IP permissions for the security group rule. You must specify either IP permissions or a
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(Collection<IpPermission> ipPermissions);

        /**
         * <p>
         * The IP permissions for the security group rule. You must specify either IP permissions or a description.
         * </p>
         * 
         * @param ipPermissions
         *        The IP permissions for the security group rule. You must specify either IP permissions or a
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPermissions(IpPermission... ipPermissions);

        /**
         * <p>
         * The IP permissions for the security group rule. You must specify either IP permissions or a description.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPermissions(List<IpPermission>)}.
         * 
         * @param ipPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPermissions(java.util.Collection<IpPermission>)
         */
        Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions);

        /**
         * <p>
         * The description for the ingress security group rules. You must specify either a description or IP
         * permissions.
         * </p>
         * 
         * @param securityGroupRuleDescriptions
         *        The description for the ingress security group rules. You must specify either a description or IP
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> securityGroupRuleDescriptions);

        /**
         * <p>
         * The description for the ingress security group rules. You must specify either a description or IP
         * permissions.
         * </p>
         * 
         * @param securityGroupRuleDescriptions
         *        The description for the ingress security group rules. You must specify either a description or IP
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleDescriptions(SecurityGroupRuleDescription... securityGroupRuleDescriptions);

        /**
         * <p>
         * The description for the ingress security group rules. You must specify either a description or IP
         * permissions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #securityGroupRuleDescriptions(List<SecurityGroupRuleDescription>)}.
         * 
         * @param securityGroupRuleDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupRuleDescriptions(java.util.Collection<SecurityGroupRuleDescription>)
         */
        Builder securityGroupRuleDescriptions(Consumer<SecurityGroupRuleDescription.Builder>... securityGroupRuleDescriptions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String groupId;

        private String groupName;

        private List<IpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<SecurityGroupRuleDescription> securityGroupRuleDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityGroupRuleDescriptionsIngressRequest model) {
            super(model);
            dryRun(model.dryRun);
            groupId(model.groupId);
            groupName(model.groupName);
            ipPermissions(model.ipPermissions);
            securityGroupRuleDescriptions(model.securityGroupRuleDescriptions);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<IpPermission.Builder> getIpPermissions() {
            List<IpPermission.Builder> result = IpPermissionListCopier.copyToBuilder(this.ipPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission... ipPermissions) {
            ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<IpPermission.Builder>... ipPermissions) {
            ipPermissions(Stream.of(ipPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SecurityGroupRuleDescription.Builder> getSecurityGroupRuleDescriptions() {
            List<SecurityGroupRuleDescription.Builder> result = SecurityGroupRuleDescriptionListCopier
                    .copyToBuilder(this.securityGroupRuleDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupRuleDescriptions(
                Collection<SecurityGroupRuleDescription.BuilderImpl> securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions = SecurityGroupRuleDescriptionListCopier
                    .copyFromBuilder(securityGroupRuleDescriptions);
        }

        @Override
        public final Builder securityGroupRuleDescriptions(Collection<SecurityGroupRuleDescription> securityGroupRuleDescriptions) {
            this.securityGroupRuleDescriptions = SecurityGroupRuleDescriptionListCopier.copy(securityGroupRuleDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRuleDescriptions(SecurityGroupRuleDescription... securityGroupRuleDescriptions) {
            securityGroupRuleDescriptions(Arrays.asList(securityGroupRuleDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupRuleDescriptions(
                Consumer<SecurityGroupRuleDescription.Builder>... securityGroupRuleDescriptions) {
            securityGroupRuleDescriptions(Stream.of(securityGroupRuleDescriptions)
                    .map(c -> SecurityGroupRuleDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityGroupRuleDescriptionsIngressRequest build() {
            return new UpdateSecurityGroupRuleDescriptionsIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
