/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartInstancesResponse extends Ec2Response implements
        ToCopyableBuilder<StartInstancesResponse.Builder, StartInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> STARTING_INSTANCES_FIELD = SdkField
            .<List<InstanceStateChange>> builder(MarshallingType.LIST)
            .memberName("StartingInstances")
            .getter(getter(StartInstancesResponse::startingInstances))
            .setter(setter(Builder::startingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet")
                    .unmarshallLocationName("instancesSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_INSTANCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstancesSet", STARTING_INSTANCES_FIELD);
                }
            });

    private final List<InstanceStateChange> startingInstances;

    private StartInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.startingInstances = builder.startingInstances;
    }

    /**
     * For responses, this returns true if the service returned a value for the StartingInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStartingInstances() {
        return startingInstances != null && !(startingInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the started instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStartingInstances} method.
     * </p>
     * 
     * @return Information about the started instances.
     */
    public final List<InstanceStateChange> startingInstances() {
        return startingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStartingInstances() ? startingInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesResponse)) {
            return false;
        }
        StartInstancesResponse other = (StartInstancesResponse) obj;
        return hasStartingInstances() == other.hasStartingInstances()
                && Objects.equals(startingInstances(), other.startingInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartInstancesResponse")
                .add("StartingInstances", hasStartingInstances() ? startingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingInstances":
            return Optional.ofNullable(clazz.cast(startingInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartInstancesResponse, T> g) {
        return obj -> g.apply((StartInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, StartInstancesResponse> {
        /**
         * <p>
         * Information about the started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about the started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(Collection<InstanceStateChange> startingInstances);

        /**
         * <p>
         * Information about the started instances.
         * </p>
         * 
         * @param startingInstances
         *        Information about the started instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingInstances(InstanceStateChange... startingInstances);

        /**
         * <p>
         * Information about the started instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceStateChange.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.InstanceStateChange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceStateChange.Builder#build()} is called immediately
         * and its result is passed to {@link #startingInstances(List<InstanceStateChange>)}.
         * 
         * @param startingInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceStateChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startingInstances(java.util.Collection<InstanceStateChange>)
         */
        Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> startingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesResponse model) {
            super(model);
            startingInstances(model.startingInstances);
        }

        public final List<InstanceStateChange.Builder> getStartingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.startingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStartingInstances(Collection<InstanceStateChange.BuilderImpl> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copyFromBuilder(startingInstances);
        }

        @Override
        public final Builder startingInstances(Collection<InstanceStateChange> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copy(startingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(InstanceStateChange... startingInstances) {
            startingInstances(Arrays.asList(startingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(Consumer<InstanceStateChange.Builder>... startingInstances) {
            startingInstances(Stream.of(startingInstances).map(c -> InstanceStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StartInstancesResponse build() {
            return new StartInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
