/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stale security group (a security group that contains stale rules).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaleSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<StaleSecurityGroup.Builder, StaleSecurityGroup> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(StaleSecurityGroup::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(StaleSecurityGroup::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(StaleSecurityGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<List<StaleIpPermission>> STALE_IP_PERMISSIONS_FIELD = SdkField
            .<List<StaleIpPermission>> builder(MarshallingType.LIST)
            .memberName("StaleIpPermissions")
            .getter(getter(StaleSecurityGroup::staleIpPermissions))
            .setter(setter(Builder::staleIpPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleIpPermissions")
                    .unmarshallLocationName("staleIpPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<StaleIpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(StaleIpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<StaleIpPermission>> STALE_IP_PERMISSIONS_EGRESS_FIELD = SdkField
            .<List<StaleIpPermission>> builder(MarshallingType.LIST)
            .memberName("StaleIpPermissionsEgress")
            .getter(getter(StaleSecurityGroup::staleIpPermissionsEgress))
            .setter(setter(Builder::staleIpPermissionsEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleIpPermissionsEgress")
                    .unmarshallLocationName("staleIpPermissionsEgress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<StaleIpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(StaleIpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcId")
            .getter(getter(StaleSecurityGroup::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUP_ID_FIELD, GROUP_NAME_FIELD, STALE_IP_PERMISSIONS_FIELD, STALE_IP_PERMISSIONS_EGRESS_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Description", DESCRIPTION_FIELD);
                    put("GroupId", GROUP_ID_FIELD);
                    put("GroupName", GROUP_NAME_FIELD);
                    put("StaleIpPermissions", STALE_IP_PERMISSIONS_FIELD);
                    put("StaleIpPermissionsEgress", STALE_IP_PERMISSIONS_EGRESS_FIELD);
                    put("VpcId", VPC_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String groupId;

    private final String groupName;

    private final List<StaleIpPermission> staleIpPermissions;

    private final List<StaleIpPermission> staleIpPermissionsEgress;

    private final String vpcId;

    private StaleSecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.staleIpPermissions = builder.staleIpPermissions;
        this.staleIpPermissionsEgress = builder.staleIpPermissionsEgress;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The description of the security group.
     * </p>
     * 
     * @return The description of the security group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaleIpPermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaleIpPermissions() {
        return staleIpPermissions != null && !(staleIpPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stale inbound rules in the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaleIpPermissions} method.
     * </p>
     * 
     * @return Information about the stale inbound rules in the security group.
     */
    public final List<StaleIpPermission> staleIpPermissions() {
        return staleIpPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaleIpPermissionsEgress property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasStaleIpPermissionsEgress() {
        return staleIpPermissionsEgress != null && !(staleIpPermissionsEgress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the stale outbound rules in the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaleIpPermissionsEgress} method.
     * </p>
     * 
     * @return Information about the stale outbound rules in the security group.
     */
    public final List<StaleIpPermission> staleIpPermissionsEgress() {
        return staleIpPermissionsEgress;
    }

    /**
     * <p>
     * The ID of the VPC for the security group.
     * </p>
     * 
     * @return The ID of the VPC for the security group.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaleIpPermissions() ? staleIpPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStaleIpPermissionsEgress() ? staleIpPermissionsEgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(groupName(), other.groupName()) && hasStaleIpPermissions() == other.hasStaleIpPermissions()
                && Objects.equals(staleIpPermissions(), other.staleIpPermissions())
                && hasStaleIpPermissionsEgress() == other.hasStaleIpPermissionsEgress()
                && Objects.equals(staleIpPermissionsEgress(), other.staleIpPermissionsEgress())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaleSecurityGroup").add("Description", description()).add("GroupId", groupId())
                .add("GroupName", groupName()).add("StaleIpPermissions", hasStaleIpPermissions() ? staleIpPermissions() : null)
                .add("StaleIpPermissionsEgress", hasStaleIpPermissionsEgress() ? staleIpPermissionsEgress() : null)
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "StaleIpPermissions":
            return Optional.ofNullable(clazz.cast(staleIpPermissions()));
        case "StaleIpPermissionsEgress":
            return Optional.ofNullable(clazz.cast(staleIpPermissionsEgress()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StaleSecurityGroup, T> g) {
        return obj -> g.apply((StaleSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaleSecurityGroup> {
        /**
         * <p>
         * The description of the security group.
         * </p>
         * 
         * @param description
         *        The description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Information about the stale inbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissions
         *        Information about the stale inbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions);

        /**
         * <p>
         * Information about the stale inbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissions
         *        Information about the stale inbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissions(StaleIpPermission... staleIpPermissions);

        /**
         * <p>
         * Information about the stale inbound rules in the security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #staleIpPermissions(List<StaleIpPermission>)}.
         * 
         * @param staleIpPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staleIpPermissions(java.util.Collection<StaleIpPermission>)
         */
        Builder staleIpPermissions(Consumer<StaleIpPermission.Builder>... staleIpPermissions);

        /**
         * <p>
         * Information about the stale outbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissionsEgress
         *        Information about the stale outbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress);

        /**
         * <p>
         * Information about the stale outbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissionsEgress
         *        Information about the stale outbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissionsEgress(StaleIpPermission... staleIpPermissionsEgress);

        /**
         * <p>
         * Information about the stale outbound rules in the security group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #staleIpPermissionsEgress(List<StaleIpPermission>)}.
         * 
         * @param staleIpPermissionsEgress
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.StaleIpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staleIpPermissionsEgress(java.util.Collection<StaleIpPermission>)
         */
        Builder staleIpPermissionsEgress(Consumer<StaleIpPermission.Builder>... staleIpPermissionsEgress);

        /**
         * <p>
         * The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String groupId;

        private String groupName;

        private List<StaleIpPermission> staleIpPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<StaleIpPermission> staleIpPermissionsEgress = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleSecurityGroup model) {
            description(model.description);
            groupId(model.groupId);
            groupName(model.groupName);
            staleIpPermissions(model.staleIpPermissions);
            staleIpPermissionsEgress(model.staleIpPermissionsEgress);
            vpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<StaleIpPermission.Builder> getStaleIpPermissions() {
            List<StaleIpPermission.Builder> result = StaleIpPermissionSetCopier.copyToBuilder(this.staleIpPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaleIpPermissions(Collection<StaleIpPermission.BuilderImpl> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissions);
        }

        @Override
        public final Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(StaleIpPermission... staleIpPermissions) {
            staleIpPermissions(Arrays.asList(staleIpPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(Consumer<StaleIpPermission.Builder>... staleIpPermissions) {
            staleIpPermissions(Stream.of(staleIpPermissions).map(c -> StaleIpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StaleIpPermission.Builder> getStaleIpPermissionsEgress() {
            List<StaleIpPermission.Builder> result = StaleIpPermissionSetCopier.copyToBuilder(this.staleIpPermissionsEgress);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaleIpPermissionsEgress(Collection<StaleIpPermission.BuilderImpl> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissionsEgress);
        }

        @Override
        public final Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(StaleIpPermission... staleIpPermissionsEgress) {
            staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(Consumer<StaleIpPermission.Builder>... staleIpPermissionsEgress) {
            staleIpPermissionsEgress(Stream.of(staleIpPermissionsEgress)
                    .map(c -> StaleIpPermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public StaleSecurityGroup build() {
            return new StaleSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
