/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a root volume replacement task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplaceRootVolumeTask implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplaceRootVolumeTask.Builder, ReplaceRootVolumeTask> {
    private static final SdkField<String> REPLACE_ROOT_VOLUME_TASK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplaceRootVolumeTaskId")
            .getter(getter(ReplaceRootVolumeTask::replaceRootVolumeTaskId))
            .setter(setter(Builder::replaceRootVolumeTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRootVolumeTaskId")
                    .unmarshallLocationName("replaceRootVolumeTaskId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ReplaceRootVolumeTask::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> TASK_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TaskState")
            .getter(getter(ReplaceRootVolumeTask::taskStateAsString))
            .setter(setter(Builder::taskState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskState")
                    .unmarshallLocationName("taskState").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StartTime")
            .getter(getter(ReplaceRootVolumeTask::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> COMPLETE_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompleteTime")
            .getter(getter(ReplaceRootVolumeTask::completeTime))
            .setter(setter(Builder::completeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteTime")
                    .unmarshallLocationName("completeTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ReplaceRootVolumeTask::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageId")
            .getter(getter(ReplaceRootVolumeTask::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(ReplaceRootVolumeTask::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Boolean> DELETE_REPLACED_ROOT_VOLUME_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteReplacedRootVolume")
            .getter(getter(ReplaceRootVolumeTask::deleteReplacedRootVolume))
            .setter(setter(Builder::deleteReplacedRootVolume))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteReplacedRootVolume")
                    .unmarshallLocationName("deleteReplacedRootVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLACE_ROOT_VOLUME_TASK_ID_FIELD, INSTANCE_ID_FIELD, TASK_STATE_FIELD, START_TIME_FIELD, COMPLETE_TIME_FIELD,
            TAGS_FIELD, IMAGE_ID_FIELD, SNAPSHOT_ID_FIELD, DELETE_REPLACED_ROOT_VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ReplaceRootVolumeTaskId", REPLACE_ROOT_VOLUME_TASK_ID_FIELD);
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("TaskState", TASK_STATE_FIELD);
                    put("StartTime", START_TIME_FIELD);
                    put("CompleteTime", COMPLETE_TIME_FIELD);
                    put("TagSet", TAGS_FIELD);
                    put("ImageId", IMAGE_ID_FIELD);
                    put("SnapshotId", SNAPSHOT_ID_FIELD);
                    put("DeleteReplacedRootVolume", DELETE_REPLACED_ROOT_VOLUME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String replaceRootVolumeTaskId;

    private final String instanceId;

    private final String taskState;

    private final String startTime;

    private final String completeTime;

    private final List<Tag> tags;

    private final String imageId;

    private final String snapshotId;

    private final Boolean deleteReplacedRootVolume;

    private ReplaceRootVolumeTask(BuilderImpl builder) {
        this.replaceRootVolumeTaskId = builder.replaceRootVolumeTaskId;
        this.instanceId = builder.instanceId;
        this.taskState = builder.taskState;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.tags = builder.tags;
        this.imageId = builder.imageId;
        this.snapshotId = builder.snapshotId;
        this.deleteReplacedRootVolume = builder.deleteReplacedRootVolume;
    }

    /**
     * <p>
     * The ID of the root volume replacement task.
     * </p>
     * 
     * @return The ID of the root volume replacement task.
     */
    public final String replaceRootVolumeTaskId() {
        return replaceRootVolumeTaskId;
    }

    /**
     * <p>
     * The ID of the instance for which the root volume replacement task was created.
     * </p>
     * 
     * @return The ID of the instance for which the root volume replacement task was created.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The state of the task. The task can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending</code> - the replacement volume is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in-progress</code> - the original volume is being detached and the replacement volume is being attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the instance
     * is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code> - the replacement task is in the process of failing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - the replacement task has failed but the original root volume is still attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing-detached</code> - the replacement task is in the process of failing. The instance might have no
     * root volume attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed-detached</code> - the replacement task has failed and the instance has no root volume attached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskState} will
     * return {@link ReplaceRootVolumeTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStateAsString}.
     * </p>
     * 
     * @return The state of the task. The task can be in one of the following states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending</code> - the replacement volume is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>in-progress</code> - the original volume is being detached and the replacement volume is being
     *         attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
     *         instance is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failing</code> - the replacement task is in the process of failing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - the replacement task has failed but the original root volume is still attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failing-detached</code> - the replacement task is in the process of failing. The instance might
     *         have no root volume attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed-detached</code> - the replacement task has failed and the instance has no root volume
     *         attached.
     *         </p>
     *         </li>
     * @see ReplaceRootVolumeTaskState
     */
    public final ReplaceRootVolumeTaskState taskState() {
        return ReplaceRootVolumeTaskState.fromValue(taskState);
    }

    /**
     * <p>
     * The state of the task. The task can be in one of the following states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending</code> - the replacement volume is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in-progress</code> - the original volume is being detached and the replacement volume is being attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the instance
     * is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing</code> - the replacement task is in the process of failing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code> - the replacement task has failed but the original root volume is still attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failing-detached</code> - the replacement task is in the process of failing. The instance might have no
     * root volume attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed-detached</code> - the replacement task has failed and the instance has no root volume attached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskState} will
     * return {@link ReplaceRootVolumeTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStateAsString}.
     * </p>
     * 
     * @return The state of the task. The task can be in one of the following states:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending</code> - the replacement volume is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>in-progress</code> - the original volume is being detached and the replacement volume is being
     *         attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
     *         instance is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failing</code> - the replacement task is in the process of failing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code> - the replacement task has failed but the original root volume is still attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failing-detached</code> - the replacement task is in the process of failing. The instance might
     *         have no root volume attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed-detached</code> - the replacement task has failed and the instance has no root volume
     *         attached.
     *         </p>
     *         </li>
     * @see ReplaceRootVolumeTaskState
     */
    public final String taskStateAsString() {
        return taskState;
    }

    /**
     * <p>
     * The time the task was started.
     * </p>
     * 
     * @return The time the task was started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the task completed.
     * </p>
     * 
     * @return The time the task completed.
     */
    public final String completeTime() {
        return completeTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the task.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the AMI used to create the replacement root volume.
     * </p>
     * 
     * @return The ID of the AMI used to create the replacement root volume.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The ID of the snapshot used to create the replacement root volume.
     * </p>
     * 
     * @return The ID of the snapshot used to create the replacement root volume.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * Indicates whether the original root volume is to be deleted after the root volume replacement task completes.
     * </p>
     * 
     * @return Indicates whether the original root volume is to be deleted after the root volume replacement task
     *         completes.
     */
    public final Boolean deleteReplacedRootVolume() {
        return deleteReplacedRootVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replaceRootVolumeTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteReplacedRootVolume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRootVolumeTask)) {
            return false;
        }
        ReplaceRootVolumeTask other = (ReplaceRootVolumeTask) obj;
        return Objects.equals(replaceRootVolumeTaskId(), other.replaceRootVolumeTaskId())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(taskStateAsString(), other.taskStateAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(completeTime(), other.completeTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(deleteReplacedRootVolume(), other.deleteReplacedRootVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplaceRootVolumeTask").add("ReplaceRootVolumeTaskId", replaceRootVolumeTaskId())
                .add("InstanceId", instanceId()).add("TaskState", taskStateAsString()).add("StartTime", startTime())
                .add("CompleteTime", completeTime()).add("Tags", hasTags() ? tags() : null).add("ImageId", imageId())
                .add("SnapshotId", snapshotId()).add("DeleteReplacedRootVolume", deleteReplacedRootVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplaceRootVolumeTaskId":
            return Optional.ofNullable(clazz.cast(replaceRootVolumeTaskId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "TaskState":
            return Optional.ofNullable(clazz.cast(taskStateAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "CompleteTime":
            return Optional.ofNullable(clazz.cast(completeTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "DeleteReplacedRootVolume":
            return Optional.ofNullable(clazz.cast(deleteReplacedRootVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRootVolumeTask, T> g) {
        return obj -> g.apply((ReplaceRootVolumeTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplaceRootVolumeTask> {
        /**
         * <p>
         * The ID of the root volume replacement task.
         * </p>
         * 
         * @param replaceRootVolumeTaskId
         *        The ID of the root volume replacement task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceRootVolumeTaskId(String replaceRootVolumeTaskId);

        /**
         * <p>
         * The ID of the instance for which the root volume replacement task was created.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance for which the root volume replacement task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The state of the task. The task can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending</code> - the replacement volume is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in-progress</code> - the original volume is being detached and the replacement volume is being
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
         * instance is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failing</code> - the replacement task is in the process of failing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - the replacement task has failed but the original root volume is still attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failing-detached</code> - the replacement task is in the process of failing. The instance might have no
         * root volume attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed-detached</code> - the replacement task has failed and the instance has no root volume attached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskState
         *        The state of the task. The task can be in one of the following states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending</code> - the replacement volume is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>in-progress</code> - the original volume is being detached and the replacement volume is being
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
         *        instance is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failing</code> - the replacement task is in the process of failing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - the replacement task has failed but the original root volume is still attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failing-detached</code> - the replacement task is in the process of failing. The instance might
         *        have no root volume attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed-detached</code> - the replacement task has failed and the instance has no root volume
         *        attached.
         *        </p>
         *        </li>
         * @see ReplaceRootVolumeTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplaceRootVolumeTaskState
         */
        Builder taskState(String taskState);

        /**
         * <p>
         * The state of the task. The task can be in one of the following states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending</code> - the replacement volume is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in-progress</code> - the original volume is being detached and the replacement volume is being
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
         * instance is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failing</code> - the replacement task is in the process of failing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code> - the replacement task has failed but the original root volume is still attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failing-detached</code> - the replacement task is in the process of failing. The instance might have no
         * root volume attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed-detached</code> - the replacement task has failed and the instance has no root volume attached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskState
         *        The state of the task. The task can be in one of the following states:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending</code> - the replacement volume is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>in-progress</code> - the original volume is being detached and the replacement volume is being
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>succeeded</code> - the replacement volume has been successfully attached to the instance and the
         *        instance is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failing</code> - the replacement task is in the process of failing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code> - the replacement task has failed but the original root volume is still attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failing-detached</code> - the replacement task is in the process of failing. The instance might
         *        have no root volume attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed-detached</code> - the replacement task has failed and the instance has no root volume
         *        attached.
         *        </p>
         *        </li>
         * @see ReplaceRootVolumeTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplaceRootVolumeTaskState
         */
        Builder taskState(ReplaceRootVolumeTaskState taskState);

        /**
         * <p>
         * The time the task was started.
         * </p>
         * 
         * @param startTime
         *        The time the task was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The time the task completed.
         * </p>
         * 
         * @param completeTime
         *        The time the task completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completeTime(String completeTime);

        /**
         * <p>
         * The tags assigned to the task.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the task.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the AMI used to create the replacement root volume.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI used to create the replacement root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The ID of the snapshot used to create the replacement root volume.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot used to create the replacement root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * Indicates whether the original root volume is to be deleted after the root volume replacement task completes.
         * </p>
         * 
         * @param deleteReplacedRootVolume
         *        Indicates whether the original root volume is to be deleted after the root volume replacement task
         *        completes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume);
    }

    static final class BuilderImpl implements Builder {
        private String replaceRootVolumeTaskId;

        private String instanceId;

        private String taskState;

        private String startTime;

        private String completeTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String imageId;

        private String snapshotId;

        private Boolean deleteReplacedRootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRootVolumeTask model) {
            replaceRootVolumeTaskId(model.replaceRootVolumeTaskId);
            instanceId(model.instanceId);
            taskState(model.taskState);
            startTime(model.startTime);
            completeTime(model.completeTime);
            tags(model.tags);
            imageId(model.imageId);
            snapshotId(model.snapshotId);
            deleteReplacedRootVolume(model.deleteReplacedRootVolume);
        }

        public final String getReplaceRootVolumeTaskId() {
            return replaceRootVolumeTaskId;
        }

        public final void setReplaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
        }

        @Override
        public final Builder replaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTaskState() {
            return taskState;
        }

        public final void setTaskState(String taskState) {
            this.taskState = taskState;
        }

        @Override
        public final Builder taskState(String taskState) {
            this.taskState = taskState;
            return this;
        }

        @Override
        public final Builder taskState(ReplaceRootVolumeTaskState taskState) {
            this.taskState(taskState == null ? null : taskState.toString());
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getCompleteTime() {
            return completeTime;
        }

        public final void setCompleteTime(String completeTime) {
            this.completeTime = completeTime;
        }

        @Override
        public final Builder completeTime(String completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getDeleteReplacedRootVolume() {
            return deleteReplacedRootVolume;
        }

        public final void setDeleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
        }

        @Override
        public final Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
            return this;
        }

        @Override
        public ReplaceRootVolumeTask build() {
            return new ReplaceRootVolumeTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
