/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTransitGatewayMulticastGroupMembersRequest extends Ec2Request
        implements
        ToCopyableBuilder<RegisterTransitGatewayMulticastGroupMembersRequest.Builder, RegisterTransitGatewayMulticastGroupMembersRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMulticastDomainId")
            .getter(getter(RegisterTransitGatewayMulticastGroupMembersRequest::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .unmarshallLocationName("TransitGatewayMulticastDomainId").build()).build();

    private static final SdkField<String> GROUP_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupIpAddress")
            .getter(getter(RegisterTransitGatewayMulticastGroupMembersRequest::groupIpAddress))
            .setter(setter(Builder::groupIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIpAddress")
                    .unmarshallLocationName("GroupIpAddress").build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaceIds")
            .getter(getter(RegisterTransitGatewayMulticastGroupMembersRequest::networkInterfaceIds))
            .setter(setter(Builder::networkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIds")
                    .unmarshallLocationName("NetworkInterfaceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(RegisterTransitGatewayMulticastGroupMembersRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, GROUP_IP_ADDRESS_FIELD, NETWORK_INTERFACE_IDS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TransitGatewayMulticastDomainId", TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD);
                    put("GroupIpAddress", GROUP_IP_ADDRESS_FIELD);
                    put("NetworkInterfaceIds", NETWORK_INTERFACE_IDS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String transitGatewayMulticastDomainId;

    private final String groupIpAddress;

    private final List<String> networkInterfaceIds;

    private final Boolean dryRun;

    private RegisterTransitGatewayMulticastGroupMembersRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.groupIpAddress = builder.groupIpAddress;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the transit gateway multicast domain.
     * </p>
     * 
     * @return The ID of the transit gateway multicast domain.
     */
    public final String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * <p>
     * The IP address assigned to the transit gateway multicast group.
     * </p>
     * 
     * @return The IP address assigned to the transit gateway multicast group.
     */
    public final String groupIpAddress() {
        return groupIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaceIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaceIds() {
        return networkInterfaceIds != null && !(networkInterfaceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The group members' network interface IDs to register with the transit gateway multicast group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceIds} method.
     * </p>
     * 
     * @return The group members' network interface IDs to register with the transit gateway multicast group.
     */
    public final List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(groupIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaceIds() ? networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTransitGatewayMulticastGroupMembersRequest)) {
            return false;
        }
        RegisterTransitGatewayMulticastGroupMembersRequest other = (RegisterTransitGatewayMulticastGroupMembersRequest) obj;
        return Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && Objects.equals(groupIpAddress(), other.groupIpAddress())
                && hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds()
                && Objects.equals(networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTransitGatewayMulticastGroupMembersRequest")
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("GroupIpAddress", groupIpAddress())
                .add("NetworkInterfaceIds", hasNetworkInterfaceIds() ? networkInterfaceIds() : null).add("DryRun", dryRun())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "GroupIpAddress":
            return Optional.ofNullable(clazz.cast(groupIpAddress()));
        case "NetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(networkInterfaceIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTransitGatewayMulticastGroupMembersRequest, T> g) {
        return obj -> g.apply((RegisterTransitGatewayMulticastGroupMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterTransitGatewayMulticastGroupMembersRequest> {
        /**
         * <p>
         * The ID of the transit gateway multicast domain.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        The ID of the transit gateway multicast domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * The IP address assigned to the transit gateway multicast group.
         * </p>
         * 
         * @param groupIpAddress
         *        The IP address assigned to the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIpAddress(String groupIpAddress);

        /**
         * <p>
         * The group members' network interface IDs to register with the transit gateway multicast group.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The group members' network interface IDs to register with the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * The group members' network interface IDs to register with the transit gateway multicast group.
         * </p>
         * 
         * @param networkInterfaceIds
         *        The group members' network interface IDs to register with the transit gateway multicast group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayMulticastDomainId;

        private String groupIpAddress;

        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTransitGatewayMulticastGroupMembersRequest model) {
            super(model);
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            groupIpAddress(model.groupIpAddress);
            networkInterfaceIds(model.networkInterfaceIds);
            dryRun(model.dryRun);
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final String getGroupIpAddress() {
            return groupIpAddress;
        }

        public final void setGroupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
        }

        @Override
        public final Builder groupIpAddress(String groupIpAddress) {
            this.groupIpAddress = groupIpAddress;
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = TransitGatewayNetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTransitGatewayMulticastGroupMembersRequest build() {
            return new RegisterTransitGatewayMulticastGroupMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
