/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrafficMirrorSessionResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyTrafficMirrorSessionResponse.Builder, ModifyTrafficMirrorSessionResponse> {
    private static final SdkField<TrafficMirrorSession> TRAFFIC_MIRROR_SESSION_FIELD = SdkField
            .<TrafficMirrorSession> builder(MarshallingType.SDK_POJO)
            .memberName("TrafficMirrorSession")
            .getter(getter(ModifyTrafficMirrorSessionResponse::trafficMirrorSession))
            .setter(setter(Builder::trafficMirrorSession))
            .constructor(TrafficMirrorSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSession")
                    .unmarshallLocationName("trafficMirrorSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TrafficMirrorSession", TRAFFIC_MIRROR_SESSION_FIELD);
                }
            });

    private final TrafficMirrorSession trafficMirrorSession;

    private ModifyTrafficMirrorSessionResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSession = builder.trafficMirrorSession;
    }

    /**
     * <p>
     * Information about the Traffic Mirror session.
     * </p>
     * 
     * @return Information about the Traffic Mirror session.
     */
    public final TrafficMirrorSession trafficMirrorSession() {
        return trafficMirrorSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorSessionResponse)) {
            return false;
        }
        ModifyTrafficMirrorSessionResponse other = (ModifyTrafficMirrorSessionResponse) obj;
        return Objects.equals(trafficMirrorSession(), other.trafficMirrorSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTrafficMirrorSessionResponse").add("TrafficMirrorSession", trafficMirrorSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorSession":
            return Optional.ofNullable(clazz.cast(trafficMirrorSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorSessionResponse, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyTrafficMirrorSessionResponse> {
        /**
         * <p>
         * Information about the Traffic Mirror session.
         * </p>
         * 
         * @param trafficMirrorSession
         *        Information about the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorSession(TrafficMirrorSession trafficMirrorSession);

        /**
         * <p>
         * Information about the Traffic Mirror session.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrafficMirrorSession.Builder} avoiding
         * the need to create one manually via {@link TrafficMirrorSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrafficMirrorSession.Builder#build()} is called immediately and
         * its result is passed to {@link #trafficMirrorSession(TrafficMirrorSession)}.
         * 
         * @param trafficMirrorSession
         *        a consumer that will call methods on {@link TrafficMirrorSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorSession(TrafficMirrorSession)
         */
        default Builder trafficMirrorSession(Consumer<TrafficMirrorSession.Builder> trafficMirrorSession) {
            return trafficMirrorSession(TrafficMirrorSession.builder().applyMutation(trafficMirrorSession).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrafficMirrorSession trafficMirrorSession;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorSessionResponse model) {
            super(model);
            trafficMirrorSession(model.trafficMirrorSession);
        }

        public final TrafficMirrorSession.Builder getTrafficMirrorSession() {
            return trafficMirrorSession != null ? trafficMirrorSession.toBuilder() : null;
        }

        public final void setTrafficMirrorSession(TrafficMirrorSession.BuilderImpl trafficMirrorSession) {
            this.trafficMirrorSession = trafficMirrorSession != null ? trafficMirrorSession.build() : null;
        }

        @Override
        public final Builder trafficMirrorSession(TrafficMirrorSession trafficMirrorSession) {
            this.trafficMirrorSession = trafficMirrorSession;
            return this;
        }

        @Override
        public ModifyTrafficMirrorSessionResponse build() {
            return new ModifyTrafficMirrorSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
