/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportClientVpnClientCertificateRevocationListRequest extends Ec2Request
        implements
        ToCopyableBuilder<ImportClientVpnClientCertificateRevocationListRequest.Builder, ImportClientVpnClientCertificateRevocationListRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId")
            .getter(getter(ImportClientVpnClientCertificateRevocationListRequest::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId")
                    .unmarshallLocationName("ClientVpnEndpointId").build()).build();

    private static final SdkField<String> CERTIFICATE_REVOCATION_LIST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateRevocationList")
            .getter(getter(ImportClientVpnClientCertificateRevocationListRequest::certificateRevocationList))
            .setter(setter(Builder::certificateRevocationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateRevocationList")
                    .unmarshallLocationName("CertificateRevocationList").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ImportClientVpnClientCertificateRevocationListRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            CERTIFICATE_REVOCATION_LIST_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
                    put("CertificateRevocationList", CERTIFICATE_REVOCATION_LIST_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String clientVpnEndpointId;

    private final String certificateRevocationList;

    private final Boolean dryRun;

    private ImportClientVpnClientCertificateRevocationListRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.certificateRevocationList = builder.certificateRevocationList;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint to which the client certificate revocation list applies.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint to which the client certificate revocation list applies.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * The client certificate revocation list file. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate"
     * >Generate a Client Certificate Revocation List</a> in the <i>Client VPN Administrator Guide</i>.
     * </p>
     * 
     * @return The client certificate revocation list file. For more information, see <a href=
     *         "https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate"
     *         >Generate a Client Certificate Revocation List</a> in the <i>Client VPN Administrator Guide</i>.
     */
    public final String certificateRevocationList() {
        return certificateRevocationList;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(certificateRevocationList());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportClientVpnClientCertificateRevocationListRequest)) {
            return false;
        }
        ImportClientVpnClientCertificateRevocationListRequest other = (ImportClientVpnClientCertificateRevocationListRequest) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(certificateRevocationList(), other.certificateRevocationList())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportClientVpnClientCertificateRevocationListRequest")
                .add("ClientVpnEndpointId", clientVpnEndpointId()).add("CertificateRevocationList", certificateRevocationList())
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "CertificateRevocationList":
            return Optional.ofNullable(clazz.cast(certificateRevocationList()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportClientVpnClientCertificateRevocationListRequest, T> g) {
        return obj -> g.apply((ImportClientVpnClientCertificateRevocationListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportClientVpnClientCertificateRevocationListRequest> {
        /**
         * <p>
         * The ID of the Client VPN endpoint to which the client certificate revocation list applies.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint to which the client certificate revocation list applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * The client certificate revocation list file. For more information, see <a href=
         * "https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate"
         * >Generate a Client Certificate Revocation List</a> in the <i>Client VPN Administrator Guide</i>.
         * </p>
         * 
         * @param certificateRevocationList
         *        The client certificate revocation list file. For more information, see <a href=
         *        "https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate"
         *        >Generate a Client Certificate Revocation List</a> in the <i>Client VPN Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateRevocationList(String certificateRevocationList);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String certificateRevocationList;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportClientVpnClientCertificateRevocationListRequest model) {
            super(model);
            clientVpnEndpointId(model.clientVpnEndpointId);
            certificateRevocationList(model.certificateRevocationList);
            dryRun(model.dryRun);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getCertificateRevocationList() {
            return certificateRevocationList;
        }

        public final void setCertificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
        }

        @Override
        public final Builder certificateRevocationList(String certificateRevocationList) {
            this.certificateRevocationList = certificateRevocationList;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportClientVpnClientCertificateRevocationListRequest build() {
            return new ImportClientVpnClientCertificateRevocationListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
