/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetReservedInstancesExchangeQuote.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservedInstancesExchangeQuoteResponse extends Ec2Response implements
        ToCopyableBuilder<GetReservedInstancesExchangeQuoteResponse.Builder, GetReservedInstancesExchangeQuoteResponse> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::currencyCode))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<Boolean> IS_VALID_EXCHANGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsValidExchange")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::isValidExchange))
            .setter(setter(Builder::isValidExchange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsValidExchange")
                    .unmarshallLocationName("isValidExchange").build()).build();

    private static final SdkField<Instant> OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("OutputReservedInstancesWillExpireAt")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::outputReservedInstancesWillExpireAt))
            .setter(setter(Builder::outputReservedInstancesWillExpireAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OutputReservedInstancesWillExpireAt")
                    .unmarshallLocationName("outputReservedInstancesWillExpireAt").build()).build();

    private static final SdkField<String> PAYMENT_DUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PaymentDue")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::paymentDue))
            .setter(setter(Builder::paymentDue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentDue")
                    .unmarshallLocationName("paymentDue").build()).build();

    private static final SdkField<ReservationValue> RESERVED_INSTANCE_VALUE_ROLLUP_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .memberName("ReservedInstanceValueRollup")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueRollup))
            .setter(setter(Builder::reservedInstanceValueRollup))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueRollup")
                    .unmarshallLocationName("reservedInstanceValueRollup").build()).build();

    private static final SdkField<List<ReservedInstanceReservationValue>> RESERVED_INSTANCE_VALUE_SET_FIELD = SdkField
            .<List<ReservedInstanceReservationValue>> builder(MarshallingType.LIST)
            .memberName("ReservedInstanceValueSet")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::reservedInstanceValueSet))
            .setter(setter(Builder::reservedInstanceValueSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceValueSet")
                    .unmarshallLocationName("reservedInstanceValueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ReservedInstanceReservationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedInstanceReservationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<ReservationValue> TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .memberName("TargetConfigurationValueRollup")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueRollup))
            .setter(setter(Builder::targetConfigurationValueRollup))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueRollup")
                    .unmarshallLocationName("targetConfigurationValueRollup").build()).build();

    private static final SdkField<List<TargetReservationValue>> TARGET_CONFIGURATION_VALUE_SET_FIELD = SdkField
            .<List<TargetReservationValue>> builder(MarshallingType.LIST)
            .memberName("TargetConfigurationValueSet")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::targetConfigurationValueSet))
            .setter(setter(Builder::targetConfigurationValueSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfigurationValueSet")
                    .unmarshallLocationName("targetConfigurationValueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TargetReservationValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetReservationValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VALIDATION_FAILURE_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ValidationFailureReason")
            .getter(getter(GetReservedInstancesExchangeQuoteResponse::validationFailureReason))
            .setter(setter(Builder::validationFailureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailureReason")
                    .unmarshallLocationName("validationFailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            IS_VALID_EXCHANGE_FIELD, OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD, PAYMENT_DUE_FIELD,
            RESERVED_INSTANCE_VALUE_ROLLUP_FIELD, RESERVED_INSTANCE_VALUE_SET_FIELD, TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD,
            TARGET_CONFIGURATION_VALUE_SET_FIELD, VALIDATION_FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CurrencyCode", CURRENCY_CODE_FIELD);
                    put("IsValidExchange", IS_VALID_EXCHANGE_FIELD);
                    put("OutputReservedInstancesWillExpireAt", OUTPUT_RESERVED_INSTANCES_WILL_EXPIRE_AT_FIELD);
                    put("PaymentDue", PAYMENT_DUE_FIELD);
                    put("ReservedInstanceValueRollup", RESERVED_INSTANCE_VALUE_ROLLUP_FIELD);
                    put("ReservedInstanceValueSet", RESERVED_INSTANCE_VALUE_SET_FIELD);
                    put("TargetConfigurationValueRollup", TARGET_CONFIGURATION_VALUE_ROLLUP_FIELD);
                    put("TargetConfigurationValueSet", TARGET_CONFIGURATION_VALUE_SET_FIELD);
                    put("ValidationFailureReason", VALIDATION_FAILURE_REASON_FIELD);
                }
            });

    private final String currencyCode;

    private final Boolean isValidExchange;

    private final Instant outputReservedInstancesWillExpireAt;

    private final String paymentDue;

    private final ReservationValue reservedInstanceValueRollup;

    private final List<ReservedInstanceReservationValue> reservedInstanceValueSet;

    private final ReservationValue targetConfigurationValueRollup;

    private final List<TargetReservationValue> targetConfigurationValueSet;

    private final String validationFailureReason;

    private GetReservedInstancesExchangeQuoteResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.isValidExchange = builder.isValidExchange;
        this.outputReservedInstancesWillExpireAt = builder.outputReservedInstancesWillExpireAt;
        this.paymentDue = builder.paymentDue;
        this.reservedInstanceValueRollup = builder.reservedInstanceValueRollup;
        this.reservedInstanceValueSet = builder.reservedInstanceValueSet;
        this.targetConfigurationValueRollup = builder.targetConfigurationValueRollup;
        this.targetConfigurationValueSet = builder.targetConfigurationValueSet;
        this.validationFailureReason = builder.validationFailureReason;
    }

    /**
     * <p>
     * The currency of the transaction.
     * </p>
     * 
     * @return The currency of the transaction.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     * </p>
     * 
     * @return If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
     */
    public final Boolean isValidExchange() {
        return isValidExchange;
    }

    /**
     * <p>
     * The new end date of the reservation term.
     * </p>
     * 
     * @return The new end date of the reservation term.
     */
    public final Instant outputReservedInstancesWillExpireAt() {
        return outputReservedInstancesWillExpireAt;
    }

    /**
     * <p>
     * The total true upfront charge for the exchange.
     * </p>
     * 
     * @return The total true upfront charge for the exchange.
     */
    public final String paymentDue() {
        return paymentDue;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public final ReservationValue reservedInstanceValueRollup() {
        return reservedInstanceValueRollup;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedInstanceValueSet property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedInstanceValueSet() {
        return reservedInstanceValueSet != null && !(reservedInstanceValueSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of your Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedInstanceValueSet} method.
     * </p>
     * 
     * @return The configuration of your Convertible Reserved Instances.
     */
    public final List<ReservedInstanceReservationValue> reservedInstanceValueSet() {
        return reservedInstanceValueSet;
    }

    /**
     * <p>
     * The cost associated with the Reserved Instance.
     * </p>
     * 
     * @return The cost associated with the Reserved Instance.
     */
    public final ReservationValue targetConfigurationValueRollup() {
        return targetConfigurationValueRollup;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetConfigurationValueSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetConfigurationValueSet() {
        return targetConfigurationValueSet != null && !(targetConfigurationValueSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of the target Convertible Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetConfigurationValueSet} method.
     * </p>
     * 
     * @return The values of the target Convertible Reserved Instances.
     */
    public final List<TargetReservationValue> targetConfigurationValueSet() {
        return targetConfigurationValueSet;
    }

    /**
     * <p>
     * Describes the reason why the exchange cannot be completed.
     * </p>
     * 
     * @return Describes the reason why the exchange cannot be completed.
     */
    public final String validationFailureReason() {
        return validationFailureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(isValidExchange());
        hashCode = 31 * hashCode + Objects.hashCode(outputReservedInstancesWillExpireAt());
        hashCode = 31 * hashCode + Objects.hashCode(paymentDue());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedInstanceValueSet() ? reservedInstanceValueSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetConfigurationValueRollup());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetConfigurationValueSet() ? targetConfigurationValueSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validationFailureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedInstancesExchangeQuoteResponse)) {
            return false;
        }
        GetReservedInstancesExchangeQuoteResponse other = (GetReservedInstancesExchangeQuoteResponse) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(isValidExchange(), other.isValidExchange())
                && Objects.equals(outputReservedInstancesWillExpireAt(), other.outputReservedInstancesWillExpireAt())
                && Objects.equals(paymentDue(), other.paymentDue())
                && Objects.equals(reservedInstanceValueRollup(), other.reservedInstanceValueRollup())
                && hasReservedInstanceValueSet() == other.hasReservedInstanceValueSet()
                && Objects.equals(reservedInstanceValueSet(), other.reservedInstanceValueSet())
                && Objects.equals(targetConfigurationValueRollup(), other.targetConfigurationValueRollup())
                && hasTargetConfigurationValueSet() == other.hasTargetConfigurationValueSet()
                && Objects.equals(targetConfigurationValueSet(), other.targetConfigurationValueSet())
                && Objects.equals(validationFailureReason(), other.validationFailureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservedInstancesExchangeQuoteResponse").add("CurrencyCode", currencyCode())
                .add("IsValidExchange", isValidExchange())
                .add("OutputReservedInstancesWillExpireAt", outputReservedInstancesWillExpireAt())
                .add("PaymentDue", paymentDue()).add("ReservedInstanceValueRollup", reservedInstanceValueRollup())
                .add("ReservedInstanceValueSet", hasReservedInstanceValueSet() ? reservedInstanceValueSet() : null)
                .add("TargetConfigurationValueRollup", targetConfigurationValueRollup())
                .add("TargetConfigurationValueSet", hasTargetConfigurationValueSet() ? targetConfigurationValueSet() : null)
                .add("ValidationFailureReason", validationFailureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "IsValidExchange":
            return Optional.ofNullable(clazz.cast(isValidExchange()));
        case "OutputReservedInstancesWillExpireAt":
            return Optional.ofNullable(clazz.cast(outputReservedInstancesWillExpireAt()));
        case "PaymentDue":
            return Optional.ofNullable(clazz.cast(paymentDue()));
        case "ReservedInstanceValueRollup":
            return Optional.ofNullable(clazz.cast(reservedInstanceValueRollup()));
        case "ReservedInstanceValueSet":
            return Optional.ofNullable(clazz.cast(reservedInstanceValueSet()));
        case "TargetConfigurationValueRollup":
            return Optional.ofNullable(clazz.cast(targetConfigurationValueRollup()));
        case "TargetConfigurationValueSet":
            return Optional.ofNullable(clazz.cast(targetConfigurationValueSet()));
        case "ValidationFailureReason":
            return Optional.ofNullable(clazz.cast(validationFailureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedInstancesExchangeQuoteResponse, T> g) {
        return obj -> g.apply((GetReservedInstancesExchangeQuoteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservedInstancesExchangeQuoteResponse> {
        /**
         * <p>
         * The currency of the transaction.
         * </p>
         * 
         * @param currencyCode
         *        The currency of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * </p>
         * 
         * @param isValidExchange
         *        If <code>true</code>, the exchange is valid. If <code>false</code>, the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValidExchange(Boolean isValidExchange);

        /**
         * <p>
         * The new end date of the reservation term.
         * </p>
         * 
         * @param outputReservedInstancesWillExpireAt
         *        The new end date of the reservation term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt);

        /**
         * <p>
         * The total true upfront charge for the exchange.
         * </p>
         * 
         * @param paymentDue
         *        The total true upfront charge for the exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentDue(String paymentDue);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param reservedInstanceValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationValue.Builder} avoiding the
         * need to create one manually via {@link ReservationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #reservedInstanceValueRollup(ReservationValue)}.
         * 
         * @param reservedInstanceValueRollup
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceValueRollup(ReservationValue)
         */
        default Builder reservedInstanceValueRollup(Consumer<ReservationValue.Builder> reservedInstanceValueRollup) {
            return reservedInstanceValueRollup(ReservationValue.builder().applyMutation(reservedInstanceValueRollup).build());
        }

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * 
         * @param reservedInstanceValueSet
         *        The configuration of your Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet);

        /**
         * <p>
         * The configuration of your Convertible Reserved Instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #reservedInstanceValueSet(List<ReservedInstanceReservationValue>)}.
         * 
         * @param reservedInstanceValueSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstanceValueSet(java.util.Collection<ReservedInstanceReservationValue>)
         */
        Builder reservedInstanceValueSet(Consumer<ReservedInstanceReservationValue.Builder>... reservedInstanceValueSet);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * 
         * @param targetConfigurationValueRollup
         *        The cost associated with the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup);

        /**
         * <p>
         * The cost associated with the Reserved Instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationValue.Builder} avoiding the
         * need to create one manually via {@link ReservationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #targetConfigurationValueRollup(ReservationValue)}.
         * 
         * @param targetConfigurationValueRollup
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurationValueRollup(ReservationValue)
         */
        default Builder targetConfigurationValueRollup(Consumer<ReservationValue.Builder> targetConfigurationValueRollup) {
            return targetConfigurationValueRollup(ReservationValue.builder().applyMutation(targetConfigurationValueRollup)
                    .build());
        }

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * 
         * @param targetConfigurationValueSet
         *        The values of the target Convertible Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet);

        /**
         * <p>
         * The values of the target Convertible Reserved Instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TargetReservationValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.TargetReservationValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TargetReservationValue.Builder#build()} is called
         * immediately and its result is passed to {@link #targetConfigurationValueSet(List<TargetReservationValue>)}.
         * 
         * @param targetConfigurationValueSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TargetReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfigurationValueSet(java.util.Collection<TargetReservationValue>)
         */
        Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder>... targetConfigurationValueSet);

        /**
         * <p>
         * Describes the reason why the exchange cannot be completed.
         * </p>
         * 
         * @param validationFailureReason
         *        Describes the reason why the exchange cannot be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailureReason(String validationFailureReason);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String currencyCode;

        private Boolean isValidExchange;

        private Instant outputReservedInstancesWillExpireAt;

        private String paymentDue;

        private ReservationValue reservedInstanceValueRollup;

        private List<ReservedInstanceReservationValue> reservedInstanceValueSet = DefaultSdkAutoConstructList.getInstance();

        private ReservationValue targetConfigurationValueRollup;

        private List<TargetReservationValue> targetConfigurationValueSet = DefaultSdkAutoConstructList.getInstance();

        private String validationFailureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedInstancesExchangeQuoteResponse model) {
            super(model);
            currencyCode(model.currencyCode);
            isValidExchange(model.isValidExchange);
            outputReservedInstancesWillExpireAt(model.outputReservedInstancesWillExpireAt);
            paymentDue(model.paymentDue);
            reservedInstanceValueRollup(model.reservedInstanceValueRollup);
            reservedInstanceValueSet(model.reservedInstanceValueSet);
            targetConfigurationValueRollup(model.targetConfigurationValueRollup);
            targetConfigurationValueSet(model.targetConfigurationValueSet);
            validationFailureReason(model.validationFailureReason);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Boolean getIsValidExchange() {
            return isValidExchange;
        }

        public final void setIsValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
        }

        @Override
        public final Builder isValidExchange(Boolean isValidExchange) {
            this.isValidExchange = isValidExchange;
            return this;
        }

        public final Instant getOutputReservedInstancesWillExpireAt() {
            return outputReservedInstancesWillExpireAt;
        }

        public final void setOutputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
        }

        @Override
        public final Builder outputReservedInstancesWillExpireAt(Instant outputReservedInstancesWillExpireAt) {
            this.outputReservedInstancesWillExpireAt = outputReservedInstancesWillExpireAt;
            return this;
        }

        public final String getPaymentDue() {
            return paymentDue;
        }

        public final void setPaymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
        }

        @Override
        public final Builder paymentDue(String paymentDue) {
            this.paymentDue = paymentDue;
            return this;
        }

        public final ReservationValue.Builder getReservedInstanceValueRollup() {
            return reservedInstanceValueRollup != null ? reservedInstanceValueRollup.toBuilder() : null;
        }

        public final void setReservedInstanceValueRollup(ReservationValue.BuilderImpl reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup != null ? reservedInstanceValueRollup.build() : null;
        }

        @Override
        public final Builder reservedInstanceValueRollup(ReservationValue reservedInstanceValueRollup) {
            this.reservedInstanceValueRollup = reservedInstanceValueRollup;
            return this;
        }

        public final List<ReservedInstanceReservationValue.Builder> getReservedInstanceValueSet() {
            List<ReservedInstanceReservationValue.Builder> result = ReservedInstanceReservationValueSetCopier
                    .copyToBuilder(this.reservedInstanceValueSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstanceValueSet(
                Collection<ReservedInstanceReservationValue.BuilderImpl> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copyFromBuilder(reservedInstanceValueSet);
        }

        @Override
        public final Builder reservedInstanceValueSet(Collection<ReservedInstanceReservationValue> reservedInstanceValueSet) {
            this.reservedInstanceValueSet = ReservedInstanceReservationValueSetCopier.copy(reservedInstanceValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(ReservedInstanceReservationValue... reservedInstanceValueSet) {
            reservedInstanceValueSet(Arrays.asList(reservedInstanceValueSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceValueSet(
                Consumer<ReservedInstanceReservationValue.Builder>... reservedInstanceValueSet) {
            reservedInstanceValueSet(Stream.of(reservedInstanceValueSet)
                    .map(c -> ReservedInstanceReservationValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReservationValue.Builder getTargetConfigurationValueRollup() {
            return targetConfigurationValueRollup != null ? targetConfigurationValueRollup.toBuilder() : null;
        }

        public final void setTargetConfigurationValueRollup(ReservationValue.BuilderImpl targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup != null ? targetConfigurationValueRollup.build()
                    : null;
        }

        @Override
        public final Builder targetConfigurationValueRollup(ReservationValue targetConfigurationValueRollup) {
            this.targetConfigurationValueRollup = targetConfigurationValueRollup;
            return this;
        }

        public final List<TargetReservationValue.Builder> getTargetConfigurationValueSet() {
            List<TargetReservationValue.Builder> result = TargetReservationValueSetCopier
                    .copyToBuilder(this.targetConfigurationValueSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetConfigurationValueSet(
                Collection<TargetReservationValue.BuilderImpl> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copyFromBuilder(targetConfigurationValueSet);
        }

        @Override
        public final Builder targetConfigurationValueSet(Collection<TargetReservationValue> targetConfigurationValueSet) {
            this.targetConfigurationValueSet = TargetReservationValueSetCopier.copy(targetConfigurationValueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(TargetReservationValue... targetConfigurationValueSet) {
            targetConfigurationValueSet(Arrays.asList(targetConfigurationValueSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurationValueSet(Consumer<TargetReservationValue.Builder>... targetConfigurationValueSet) {
            targetConfigurationValueSet(Stream.of(targetConfigurationValueSet)
                    .map(c -> TargetReservationValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getValidationFailureReason() {
            return validationFailureReason;
        }

        public final void setValidationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
        }

        @Override
        public final Builder validationFailureReason(String validationFailureReason) {
            this.validationFailureReason = validationFailureReason;
            return this;
        }

        @Override
        public GetReservedInstancesExchangeQuoteResponse build() {
            return new GetReservedInstancesExchangeQuoteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
