/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpamDiscoveredPublicAddressesResponse extends Ec2Response implements
        ToCopyableBuilder<GetIpamDiscoveredPublicAddressesResponse.Builder, GetIpamDiscoveredPublicAddressesResponse> {
    private static final SdkField<List<IpamDiscoveredPublicAddress>> IPAM_DISCOVERED_PUBLIC_ADDRESSES_FIELD = SdkField
            .<List<IpamDiscoveredPublicAddress>> builder(MarshallingType.LIST)
            .memberName("IpamDiscoveredPublicAddresses")
            .getter(getter(GetIpamDiscoveredPublicAddressesResponse::ipamDiscoveredPublicAddresses))
            .setter(setter(Builder::ipamDiscoveredPublicAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamDiscoveredPublicAddressSet")
                    .unmarshallLocationName("ipamDiscoveredPublicAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamDiscoveredPublicAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamDiscoveredPublicAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> OLDEST_SAMPLE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("OldestSampleTime")
            .getter(getter(GetIpamDiscoveredPublicAddressesResponse::oldestSampleTime))
            .setter(setter(Builder::oldestSampleTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldestSampleTime")
                    .unmarshallLocationName("oldestSampleTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetIpamDiscoveredPublicAddressesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IPAM_DISCOVERED_PUBLIC_ADDRESSES_FIELD, OLDEST_SAMPLE_TIME_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("IpamDiscoveredPublicAddressSet", IPAM_DISCOVERED_PUBLIC_ADDRESSES_FIELD);
                    put("OldestSampleTime", OLDEST_SAMPLE_TIME_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses;

    private final Instant oldestSampleTime;

    private final String nextToken;

    private GetIpamDiscoveredPublicAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.ipamDiscoveredPublicAddresses = builder.ipamDiscoveredPublicAddresses;
        this.oldestSampleTime = builder.oldestSampleTime;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpamDiscoveredPublicAddresses property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIpamDiscoveredPublicAddresses() {
        return ipamDiscoveredPublicAddresses != null && !(ipamDiscoveredPublicAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IPAM discovered public addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpamDiscoveredPublicAddresses} method.
     * </p>
     * 
     * @return IPAM discovered public addresses.
     */
    public final List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses() {
        return ipamDiscoveredPublicAddresses;
    }

    /**
     * <p>
     * The oldest successful resource discovery time.
     * </p>
     * 
     * @return The oldest successful resource discovery time.
     */
    public final Instant oldestSampleTime() {
        return oldestSampleTime;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpamDiscoveredPublicAddresses() ? ipamDiscoveredPublicAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(oldestSampleTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamDiscoveredPublicAddressesResponse)) {
            return false;
        }
        GetIpamDiscoveredPublicAddressesResponse other = (GetIpamDiscoveredPublicAddressesResponse) obj;
        return hasIpamDiscoveredPublicAddresses() == other.hasIpamDiscoveredPublicAddresses()
                && Objects.equals(ipamDiscoveredPublicAddresses(), other.ipamDiscoveredPublicAddresses())
                && Objects.equals(oldestSampleTime(), other.oldestSampleTime()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetIpamDiscoveredPublicAddressesResponse")
                .add("IpamDiscoveredPublicAddresses", hasIpamDiscoveredPublicAddresses() ? ipamDiscoveredPublicAddresses() : null)
                .add("OldestSampleTime", oldestSampleTime()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamDiscoveredPublicAddresses":
            return Optional.ofNullable(clazz.cast(ipamDiscoveredPublicAddresses()));
        case "OldestSampleTime":
            return Optional.ofNullable(clazz.cast(oldestSampleTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIpamDiscoveredPublicAddressesResponse, T> g) {
        return obj -> g.apply((GetIpamDiscoveredPublicAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIpamDiscoveredPublicAddressesResponse> {
        /**
         * <p>
         * IPAM discovered public addresses.
         * </p>
         * 
         * @param ipamDiscoveredPublicAddresses
         *        IPAM discovered public addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamDiscoveredPublicAddresses(Collection<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses);

        /**
         * <p>
         * IPAM discovered public addresses.
         * </p>
         * 
         * @param ipamDiscoveredPublicAddresses
         *        IPAM discovered public addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamDiscoveredPublicAddresses(IpamDiscoveredPublicAddress... ipamDiscoveredPublicAddresses);

        /**
         * <p>
         * IPAM discovered public addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddress.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddress.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #ipamDiscoveredPublicAddresses(List<IpamDiscoveredPublicAddress>)}.
         * 
         * @param ipamDiscoveredPublicAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamDiscoveredPublicAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamDiscoveredPublicAddresses(java.util.Collection<IpamDiscoveredPublicAddress>)
         */
        Builder ipamDiscoveredPublicAddresses(Consumer<IpamDiscoveredPublicAddress.Builder>... ipamDiscoveredPublicAddresses);

        /**
         * <p>
         * The oldest successful resource discovery time.
         * </p>
         * 
         * @param oldestSampleTime
         *        The oldest successful resource discovery time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldestSampleTime(Instant oldestSampleTime);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses = DefaultSdkAutoConstructList.getInstance();

        private Instant oldestSampleTime;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamDiscoveredPublicAddressesResponse model) {
            super(model);
            ipamDiscoveredPublicAddresses(model.ipamDiscoveredPublicAddresses);
            oldestSampleTime(model.oldestSampleTime);
            nextToken(model.nextToken);
        }

        public final List<IpamDiscoveredPublicAddress.Builder> getIpamDiscoveredPublicAddresses() {
            List<IpamDiscoveredPublicAddress.Builder> result = IpamDiscoveredPublicAddressSetCopier
                    .copyToBuilder(this.ipamDiscoveredPublicAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamDiscoveredPublicAddresses(
                Collection<IpamDiscoveredPublicAddress.BuilderImpl> ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses = IpamDiscoveredPublicAddressSetCopier
                    .copyFromBuilder(ipamDiscoveredPublicAddresses);
        }

        @Override
        public final Builder ipamDiscoveredPublicAddresses(Collection<IpamDiscoveredPublicAddress> ipamDiscoveredPublicAddresses) {
            this.ipamDiscoveredPublicAddresses = IpamDiscoveredPublicAddressSetCopier.copy(ipamDiscoveredPublicAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredPublicAddresses(IpamDiscoveredPublicAddress... ipamDiscoveredPublicAddresses) {
            ipamDiscoveredPublicAddresses(Arrays.asList(ipamDiscoveredPublicAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamDiscoveredPublicAddresses(
                Consumer<IpamDiscoveredPublicAddress.Builder>... ipamDiscoveredPublicAddresses) {
            ipamDiscoveredPublicAddresses(Stream.of(ipamDiscoveredPublicAddresses)
                    .map(c -> IpamDiscoveredPublicAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getOldestSampleTime() {
            return oldestSampleTime;
        }

        public final void setOldestSampleTime(Instant oldestSampleTime) {
            this.oldestSampleTime = oldestSampleTime;
        }

        @Override
        public final Builder oldestSampleTime(Instant oldestSampleTime) {
            this.oldestSampleTime = oldestSampleTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamDiscoveredPublicAddressesResponse build() {
            return new GetIpamDiscoveredPublicAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
