/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeSnapshotsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeSnapshotsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<String>> OWNER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OwnerIds")
            .getter(getter(DescribeSnapshotsRequest::ownerIds))
            .setter(setter(Builder::ownerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Owner")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Owner").unmarshallLocationName("Owner").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> RESTORABLE_BY_USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RestorableByUserIds")
            .getter(getter(DescribeSnapshotsRequest::restorableByUserIds))
            .setter(setter(Builder::restorableByUserIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableBy")
                    .unmarshallLocationName("RestorableBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotIds")
            .getter(getter(DescribeSnapshotsRequest::snapshotIds))
            .setter(setter(Builder::snapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotId").unmarshallLocationName("SnapshotId").build())
                                            .build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeSnapshotsRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeSnapshotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, OWNER_IDS_FIELD, RESTORABLE_BY_USER_IDS_FIELD, SNAPSHOT_IDS_FIELD, DRY_RUN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("Owner", OWNER_IDS_FIELD);
                    put("RestorableBy", RESTORABLE_BY_USER_IDS_FIELD);
                    put("SnapshotId", SNAPSHOT_IDS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("Filter", FILTERS_FIELD);
                }
            });

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> ownerIds;

    private final List<String> restorableByUserIds;

    private final List<String> snapshotIds;

    private final Boolean dryRun;

    private final List<Filter> filters;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerIds = builder.ownerIds;
        this.restorableByUserIds = builder.restorableByUserIds;
        this.snapshotIds = builder.snapshotIds;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OwnerIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOwnerIds() {
        return ownerIds != null && !(ownerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web Services
     * account IDs, <code>self</code>, and <code>amazon</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOwnerIds} method.
     * </p>
     * 
     * @return Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web
     *         Services account IDs, <code>self</code>, and <code>amazon</code>.
     */
    public final List<String> ownerIds() {
        return ownerIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestorableByUserIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestorableByUserIds() {
        return restorableByUserIds != null && !(restorableByUserIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestorableByUserIds} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
     */
    public final List<String> restorableByUserIds() {
        return restorableByUserIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotIds() {
        return snapshotIds != null && !(snapshotIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The snapshot IDs.
     * </p>
     * <p>
     * Default: Describes the snapshots for which you have create volume permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotIds} method.
     * </p>
     * 
     * @return The snapshot IDs.</p>
     *         <p>
     *         Default: Describes the snapshots for which you have create volume permissions.
     */
    public final List<String> snapshotIds() {
        return snapshotIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>description</code> - A description of the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not the
     * user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use the
     * related parameter instead of this filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the related
     * parameter instead of this filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>snapshot-id</code> - The snapshot ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The time stamp when the snapshot was initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     * <code>error</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-id</code> - The ID of the volume the snapshot is for.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-size</code> - The size of the volume, in GiB.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>description</code> - A description of the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> |
     *         <code>false</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is
     *         not the user-configured Amazon Web Services account alias set using the IAM console. We recommend that
     *         you use the related parameter instead of this filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
     *         related parameter instead of this filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>snapshot-id</code> - The snapshot ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The time stamp when the snapshot was initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
     *         <code>error</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> |
     *         <code>standard</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-id</code> - The ID of the volume the snapshot is for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-size</code> - The size of the volume, in GiB.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOwnerIds() ? ownerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRestorableByUserIds() ? restorableByUserIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotIds() ? snapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasOwnerIds() == other.hasOwnerIds() && Objects.equals(ownerIds(), other.ownerIds())
                && hasRestorableByUserIds() == other.hasRestorableByUserIds()
                && Objects.equals(restorableByUserIds(), other.restorableByUserIds())
                && hasSnapshotIds() == other.hasSnapshotIds() && Objects.equals(snapshotIds(), other.snapshotIds())
                && Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OwnerIds", hasOwnerIds() ? ownerIds() : null)
                .add("RestorableByUserIds", hasRestorableByUserIds() ? restorableByUserIds() : null)
                .add("SnapshotIds", hasSnapshotIds() ? snapshotIds() : null).add("DryRun", dryRun())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OwnerIds":
            return Optional.ofNullable(clazz.cast(ownerIds()));
        case "RestorableByUserIds":
            return Optional.ofNullable(clazz.cast(restorableByUserIds()));
        case "SnapshotIds":
            return Optional.ofNullable(clazz.cast(snapshotIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web
         * Services account IDs, <code>self</code>, and <code>amazon</code>.
         * </p>
         * 
         * @param ownerIds
         *        Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web
         *        Services account IDs, <code>self</code>, and <code>amazon</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(Collection<String> ownerIds);

        /**
         * <p>
         * Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web
         * Services account IDs, <code>self</code>, and <code>amazon</code>.
         * </p>
         * 
         * @param ownerIds
         *        Scopes the results to snapshots with the specified owners. You can specify a combination of Amazon Web
         *        Services account IDs, <code>self</code>, and <code>amazon</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIds(String... ownerIds);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(Collection<String> restorableByUserIds);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
         * </p>
         * 
         * @param restorableByUserIds
         *        The IDs of the Amazon Web Services accounts that can create volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableByUserIds(String... restorableByUserIds);

        /**
         * <p>
         * The snapshot IDs.
         * </p>
         * <p>
         * Default: Describes the snapshots for which you have create volume permissions.
         * </p>
         * 
         * @param snapshotIds
         *        The snapshot IDs.</p>
         *        <p>
         *        Default: Describes the snapshots for which you have create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(Collection<String> snapshotIds);

        /**
         * <p>
         * The snapshot IDs.
         * </p>
         * <p>
         * Default: Describes the snapshots for which you have create volume permissions.
         * </p>
         * 
         * @param snapshotIds
         *        The snapshot IDs.</p>
         *        <p>
         *        Default: Describes the snapshots for which you have create volume permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(String... snapshotIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not
         * the user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use
         * the related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> |
         *        <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This
         *        is not the user-configured Amazon Web Services account alias set using the IAM console. We recommend
         *        that you use the related parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         *        related parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> |
         *        <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not
         * the user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use
         * the related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>description</code> - A description of the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> |
         *        <code>false</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This
         *        is not the user-configured Amazon Web Services account alias set using the IAM console. We recommend
         *        that you use the related parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         *        related parameter instead of this filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>snapshot-id</code> - The snapshot ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time stamp when the snapshot was initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         *        <code>error</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> |
         *        <code>standard</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-id</code> - The ID of the volume the snapshot is for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-size</code> - The size of the volume, in GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>description</code> - A description of the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>encrypted</code> - Indicates whether the snapshot is encrypted (<code>true</code> | <code>false</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-alias</code> - The owner alias, from an Amazon-maintained list (<code>amazon</code>). This is not
         * the user-configured Amazon Web Services account alias set using the IAM console. We recommend that you use
         * the related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The Amazon Web Services account ID of the owner. We recommend that you use the
         * related parameter instead of this filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The progress of the snapshot, as a percentage (for example, 80%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>snapshot-id</code> - The snapshot ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time stamp when the snapshot was initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the snapshot (<code>pending</code> | <code>completed</code> |
         * <code>error</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>storage-tier</code> - The storage tier of the snapshot (<code>archive</code> | <code>standard</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-id</code> - The ID of the volume the snapshot is for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-size</code> - The size of the volume, in GiB.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<String> ownerIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> restorableByUserIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            ownerIds(model.ownerIds);
            restorableByUserIds(model.restorableByUserIds);
            snapshotIds(model.snapshotIds);
            dryRun(model.dryRun);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getOwnerIds() {
            if (ownerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ownerIds;
        }

        public final void setOwnerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
        }

        @Override
        public final Builder ownerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ownerIds(String... ownerIds) {
            ownerIds(Arrays.asList(ownerIds));
            return this;
        }

        public final Collection<String> getRestorableByUserIds() {
            if (restorableByUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return restorableByUserIds;
        }

        public final void setRestorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
        }

        @Override
        public final Builder restorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableByUserIds(String... restorableByUserIds) {
            restorableByUserIds(Arrays.asList(restorableByUserIds));
            return this;
        }

        public final Collection<String> getSnapshotIds() {
            if (snapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotIds;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String... snapshotIds) {
            snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
