/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticGpusRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeElasticGpusRequest.Builder, DescribeElasticGpusRequest> {
    private static final SdkField<List<String>> ELASTIC_GPU_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuIds")
            .getter(getter(DescribeElasticGpusRequest::elasticGpuIds))
            .setter(setter(Builder::elasticGpuIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuId")
                    .unmarshallLocationName("ElasticGpuId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DescribeElasticGpusRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeElasticGpusRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeElasticGpusRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeElasticGpusRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_GPU_IDS_FIELD,
            DRY_RUN_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ElasticGpuId", ELASTIC_GPU_IDS_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                    put("Filter", FILTERS_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<String> elasticGpuIds;

    private final Boolean dryRun;

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeElasticGpusRequest(BuilderImpl builder) {
        super(builder);
        this.elasticGpuIds = builder.elasticGpuIds;
        this.dryRun = builder.dryRun;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticGpuIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasElasticGpuIds() {
        return elasticGpuIds != null && !(elasticGpuIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Graphics accelerator IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticGpuIds} method.
     * </p>
     * 
     * @return The Elastic Graphics accelerator IDs.
     */
    public final List<String> elasticGpuIds() {
        return elasticGpuIds;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
     * <code>IMPAIRED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example, <code>eg1.medium</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
     *         <code>IMPAIRED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
     *         <code>eg1.medium</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
     *         associated.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuIds() ? elasticGpuIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusRequest)) {
            return false;
        }
        DescribeElasticGpusRequest other = (DescribeElasticGpusRequest) obj;
        return hasElasticGpuIds() == other.hasElasticGpuIds() && Objects.equals(elasticGpuIds(), other.elasticGpuIds())
                && Objects.equals(dryRun(), other.dryRun()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticGpusRequest").add("ElasticGpuIds", hasElasticGpuIds() ? elasticGpuIds() : null)
                .add("DryRun", dryRun()).add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuIds":
            return Optional.ofNullable(clazz.cast(elasticGpuIds()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticGpusRequest, T> g) {
        return obj -> g.apply((DescribeElasticGpusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeElasticGpusRequest> {
        /**
         * <p>
         * The Elastic Graphics accelerator IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        The Elastic Graphics accelerator IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(Collection<String> elasticGpuIds);

        /**
         * <p>
         * The Elastic Graphics accelerator IDs.
         * </p>
         * 
         * @param elasticGpuIds
         *        The Elastic Graphics accelerator IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuIds(String... elasticGpuIds);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator
         *        resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         *        <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
         *        associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator
         *        resides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         *        <code>IMPAIRED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         *        <code>eg1.medium</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is
         *        associated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone in which the Elastic Graphics accelerator resides.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-health</code> - The status of the Elastic Graphics accelerator (<code>OK</code> |
         * <code>IMPAIRED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-state</code> - The state of the Elastic Graphics accelerator (<code>ATTACHED</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elastic-gpu-type</code> - The type of Elastic Graphics accelerator; for example,
         * <code>eg1.medium</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance to which the Elastic Graphics accelerator is associated.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> elasticGpuIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusRequest model) {
            super(model);
            elasticGpuIds(model.elasticGpuIds);
            dryRun(model.dryRun);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticGpuIds() {
            if (elasticGpuIds instanceof SdkAutoConstructList) {
                return null;
            }
            return elasticGpuIds;
        }

        public final void setElasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
        }

        @Override
        public final Builder elasticGpuIds(Collection<String> elasticGpuIds) {
            this.elasticGpuIds = ElasticGpuIdSetCopier.copy(elasticGpuIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuIds(String... elasticGpuIds) {
            elasticGpuIds(Arrays.asList(elasticGpuIds));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticGpusRequest build() {
            return new DescribeElasticGpusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
