/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A security group connection tracking specification response that enables you to set the idle timeout for connection
 * tracking on an Elastic network interface. For more information, see <a href=
 * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-connection-tracking.html#connection-tracking-timeouts"
 * >Connection tracking timeouts</a> in the <i>Amazon EC2 User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionTrackingSpecificationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionTrackingSpecificationResponse.Builder, ConnectionTrackingSpecificationResponse> {
    private static final SdkField<Integer> TCP_ESTABLISHED_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TcpEstablishedTimeout")
            .getter(getter(ConnectionTrackingSpecificationResponse::tcpEstablishedTimeout))
            .setter(setter(Builder::tcpEstablishedTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TcpEstablishedTimeout")
                    .unmarshallLocationName("tcpEstablishedTimeout").build()).build();

    private static final SdkField<Integer> UDP_STREAM_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("UdpStreamTimeout")
            .getter(getter(ConnectionTrackingSpecificationResponse::udpStreamTimeout))
            .setter(setter(Builder::udpStreamTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpStreamTimeout")
                    .unmarshallLocationName("udpStreamTimeout").build()).build();

    private static final SdkField<Integer> UDP_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("UdpTimeout")
            .getter(getter(ConnectionTrackingSpecificationResponse::udpTimeout))
            .setter(setter(Builder::udpTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UdpTimeout")
                    .unmarshallLocationName("udpTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TCP_ESTABLISHED_TIMEOUT_FIELD,
            UDP_STREAM_TIMEOUT_FIELD, UDP_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TcpEstablishedTimeout", TCP_ESTABLISHED_TIMEOUT_FIELD);
                    put("UdpStreamTimeout", UDP_STREAM_TIMEOUT_FIELD);
                    put("UdpTimeout", UDP_TIMEOUT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer tcpEstablishedTimeout;

    private final Integer udpStreamTimeout;

    private final Integer udpTimeout;

    private ConnectionTrackingSpecificationResponse(BuilderImpl builder) {
        this.tcpEstablishedTimeout = builder.tcpEstablishedTimeout;
        this.udpStreamTimeout = builder.udpStreamTimeout;
        this.udpTimeout = builder.udpTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000 seconds (5
     * days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000
     *         seconds (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
     */
    public final Integer tcpEstablishedTimeout() {
        return tcpEstablishedTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one request-response
     * transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one
     *         request-response transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
     */
    public final Integer udpStreamTimeout() {
        return udpStreamTimeout;
    }

    /**
     * <p>
     * Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
     * request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
     * </p>
     * 
     * @return Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
     *         request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
     */
    public final Integer udpTimeout() {
        return udpTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tcpEstablishedTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(udpStreamTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(udpTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionTrackingSpecificationResponse)) {
            return false;
        }
        ConnectionTrackingSpecificationResponse other = (ConnectionTrackingSpecificationResponse) obj;
        return Objects.equals(tcpEstablishedTimeout(), other.tcpEstablishedTimeout())
                && Objects.equals(udpStreamTimeout(), other.udpStreamTimeout())
                && Objects.equals(udpTimeout(), other.udpTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionTrackingSpecificationResponse").add("TcpEstablishedTimeout", tcpEstablishedTimeout())
                .add("UdpStreamTimeout", udpStreamTimeout()).add("UdpTimeout", udpTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TcpEstablishedTimeout":
            return Optional.ofNullable(clazz.cast(tcpEstablishedTimeout()));
        case "UdpStreamTimeout":
            return Optional.ofNullable(clazz.cast(udpStreamTimeout()));
        case "UdpTimeout":
            return Optional.ofNullable(clazz.cast(udpTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionTrackingSpecificationResponse, T> g) {
        return obj -> g.apply((ConnectionTrackingSpecificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionTrackingSpecificationResponse> {
        /**
         * <p>
         * Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000 seconds
         * (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
         * </p>
         * 
         * @param tcpEstablishedTimeout
         *        Timeout (in seconds) for idle TCP connections in an established state. Min: 60 seconds. Max: 432000
         *        seconds (5 days). Default: 432000 seconds. Recommended: Less than 432000 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpEstablishedTimeout(Integer tcpEstablishedTimeout);

        /**
         * <p>
         * Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one request-response
         * transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
         * </p>
         * 
         * @param udpStreamTimeout
         *        Timeout (in seconds) for idle UDP flows classified as streams which have seen more than one
         *        request-response transaction. Min: 60 seconds. Max: 180 seconds (3 minutes). Default: 180 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpStreamTimeout(Integer udpStreamTimeout);

        /**
         * <p>
         * Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
         * request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
         * </p>
         * 
         * @param udpTimeout
         *        Timeout (in seconds) for idle UDP flows that have seen traffic only in a single direction or a single
         *        request-response transaction. Min: 30 seconds. Max: 60 seconds. Default: 30 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpTimeout(Integer udpTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer tcpEstablishedTimeout;

        private Integer udpStreamTimeout;

        private Integer udpTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionTrackingSpecificationResponse model) {
            tcpEstablishedTimeout(model.tcpEstablishedTimeout);
            udpStreamTimeout(model.udpStreamTimeout);
            udpTimeout(model.udpTimeout);
        }

        public final Integer getTcpEstablishedTimeout() {
            return tcpEstablishedTimeout;
        }

        public final void setTcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
        }

        @Override
        public final Builder tcpEstablishedTimeout(Integer tcpEstablishedTimeout) {
            this.tcpEstablishedTimeout = tcpEstablishedTimeout;
            return this;
        }

        public final Integer getUdpStreamTimeout() {
            return udpStreamTimeout;
        }

        public final void setUdpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
        }

        @Override
        public final Builder udpStreamTimeout(Integer udpStreamTimeout) {
            this.udpStreamTimeout = udpStreamTimeout;
            return this;
        }

        public final Integer getUdpTimeout() {
            return udpTimeout;
        }

        public final void setUdpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
        }

        @Override
        public final Builder udpTimeout(Integer udpTimeout) {
            this.udpTimeout = udpTimeout;
            return this;
        }

        @Override
        public ConnectionTrackingSpecificationResponse build() {
            return new ConnectionTrackingSpecificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
