/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for sending VPN tunnel logs to CloudWatch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogOptions.Builder, CloudWatchLogOptions> {
    private static final SdkField<Boolean> LOG_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LogEnabled")
            .getter(getter(CloudWatchLogOptions::logEnabled))
            .setter(setter(Builder::logEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogEnabled")
                    .unmarshallLocationName("logEnabled").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LogGroupArn")
            .getter(getter(CloudWatchLogOptions::logGroupArn))
            .setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn")
                    .unmarshallLocationName("logGroupArn").build()).build();

    private static final SdkField<String> LOG_OUTPUT_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LogOutputFormat")
            .getter(getter(CloudWatchLogOptions::logOutputFormat))
            .setter(setter(Builder::logOutputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogOutputFormat")
                    .unmarshallLocationName("logOutputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ENABLED_FIELD,
            LOG_GROUP_ARN_FIELD, LOG_OUTPUT_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LogEnabled", LOG_ENABLED_FIELD);
                    put("LogGroupArn", LOG_GROUP_ARN_FIELD);
                    put("LogOutputFormat", LOG_OUTPUT_FORMAT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean logEnabled;

    private final String logGroupArn;

    private final String logOutputFormat;

    private CloudWatchLogOptions(BuilderImpl builder) {
        this.logEnabled = builder.logEnabled;
        this.logGroupArn = builder.logGroupArn;
        this.logOutputFormat = builder.logOutputFormat;
    }

    /**
     * <p>
     * Status of VPN tunnel logging feature. Default value is <code>False</code>.
     * </p>
     * <p>
     * Valid values: <code>True</code> | <code>False</code>
     * </p>
     * 
     * @return Status of VPN tunnel logging feature. Default value is <code>False</code>.</p>
     *         <p>
     *         Valid values: <code>True</code> | <code>False</code>
     */
    public final Boolean logEnabled() {
        return logEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    /**
     * <p>
     * Configured log format. Default format is <code>json</code>.
     * </p>
     * <p>
     * Valid values: <code>json</code> | <code>text</code>
     * </p>
     * 
     * @return Configured log format. Default format is <code>json</code>.</p>
     *         <p>
     *         Valid values: <code>json</code> | <code>text</code>
     */
    public final String logOutputFormat() {
        return logOutputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(logOutputFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogOptions)) {
            return false;
        }
        CloudWatchLogOptions other = (CloudWatchLogOptions) obj;
        return Objects.equals(logEnabled(), other.logEnabled()) && Objects.equals(logGroupArn(), other.logGroupArn())
                && Objects.equals(logOutputFormat(), other.logOutputFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogOptions").add("LogEnabled", logEnabled()).add("LogGroupArn", logGroupArn())
                .add("LogOutputFormat", logOutputFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogEnabled":
            return Optional.ofNullable(clazz.cast(logEnabled()));
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        case "LogOutputFormat":
            return Optional.ofNullable(clazz.cast(logOutputFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogOptions, T> g) {
        return obj -> g.apply((CloudWatchLogOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogOptions> {
        /**
         * <p>
         * Status of VPN tunnel logging feature. Default value is <code>False</code>.
         * </p>
         * <p>
         * Valid values: <code>True</code> | <code>False</code>
         * </p>
         * 
         * @param logEnabled
         *        Status of VPN tunnel logging feature. Default value is <code>False</code>.</p>
         *        <p>
         *        Valid values: <code>True</code> | <code>False</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEnabled(Boolean logEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
         * </p>
         * 
         * @param logGroupArn
         *        The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);

        /**
         * <p>
         * Configured log format. Default format is <code>json</code>.
         * </p>
         * <p>
         * Valid values: <code>json</code> | <code>text</code>
         * </p>
         * 
         * @param logOutputFormat
         *        Configured log format. Default format is <code>json</code>.</p>
         *        <p>
         *        Valid values: <code>json</code> | <code>text</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logOutputFormat(String logOutputFormat);
    }

    static final class BuilderImpl implements Builder {
        private Boolean logEnabled;

        private String logGroupArn;

        private String logOutputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogOptions model) {
            logEnabled(model.logEnabled);
            logGroupArn(model.logGroupArn);
            logOutputFormat(model.logOutputFormat);
        }

        public final Boolean getLogEnabled() {
            return logEnabled;
        }

        public final void setLogEnabled(Boolean logEnabled) {
            this.logEnabled = logEnabled;
        }

        @Override
        public final Builder logEnabled(Boolean logEnabled) {
            this.logEnabled = logEnabled;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public final String getLogOutputFormat() {
            return logOutputFormat;
        }

        public final void setLogOutputFormat(String logOutputFormat) {
            this.logOutputFormat = logOutputFormat;
        }

        @Override
        public final Builder logOutputFormat(String logOutputFormat) {
            this.logOutputFormat = logOutputFormat;
            return this;
        }

        @Override
        public CloudWatchLogOptions build() {
            return new CloudWatchLogOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
