/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTrunkInterfaceRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateTrunkInterfaceRequest.Builder, AssociateTrunkInterfaceRequest> {
    private static final SdkField<String> BRANCH_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BranchInterfaceId")
            .getter(getter(AssociateTrunkInterfaceRequest::branchInterfaceId))
            .setter(setter(Builder::branchInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchInterfaceId")
                    .unmarshallLocationName("BranchInterfaceId").build()).build();

    private static final SdkField<String> TRUNK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrunkInterfaceId")
            .getter(getter(AssociateTrunkInterfaceRequest::trunkInterfaceId))
            .setter(setter(Builder::trunkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrunkInterfaceId")
                    .unmarshallLocationName("TrunkInterfaceId").build()).build();

    private static final SdkField<Integer> VLAN_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VlanId")
            .getter(getter(AssociateTrunkInterfaceRequest::vlanId))
            .setter(setter(Builder::vlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VlanId")
                    .unmarshallLocationName("VlanId").build()).build();

    private static final SdkField<Integer> GRE_KEY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("GreKey")
            .getter(getter(AssociateTrunkInterfaceRequest::greKey))
            .setter(setter(Builder::greKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreKey")
                    .unmarshallLocationName("GreKey").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(AssociateTrunkInterfaceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(AssociateTrunkInterfaceRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_INTERFACE_ID_FIELD,
            TRUNK_INTERFACE_ID_FIELD, VLAN_ID_FIELD, GRE_KEY_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("BranchInterfaceId", BRANCH_INTERFACE_ID_FIELD);
                    put("TrunkInterfaceId", TRUNK_INTERFACE_ID_FIELD);
                    put("VlanId", VLAN_ID_FIELD);
                    put("GreKey", GRE_KEY_FIELD);
                    put("ClientToken", CLIENT_TOKEN_FIELD);
                    put("DryRun", DRY_RUN_FIELD);
                }
            });

    private final String branchInterfaceId;

    private final String trunkInterfaceId;

    private final Integer vlanId;

    private final Integer greKey;

    private final String clientToken;

    private final Boolean dryRun;

    private AssociateTrunkInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.branchInterfaceId = builder.branchInterfaceId;
        this.trunkInterfaceId = builder.trunkInterfaceId;
        this.vlanId = builder.vlanId;
        this.greKey = builder.greKey;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the branch network interface.
     * </p>
     * 
     * @return The ID of the branch network interface.
     */
    public final String branchInterfaceId() {
        return branchInterfaceId;
    }

    /**
     * <p>
     * The ID of the trunk network interface.
     * </p>
     * 
     * @return The ID of the trunk network interface.
     */
    public final String trunkInterfaceId() {
        return trunkInterfaceId;
    }

    /**
     * <p>
     * The ID of the VLAN. This applies to the VLAN protocol.
     * </p>
     * 
     * @return The ID of the VLAN. This applies to the VLAN protocol.
     */
    public final Integer vlanId() {
        return vlanId;
    }

    /**
     * <p>
     * The application key. This applies to the GRE protocol.
     * </p>
     * 
     * @return The application key. This applies to the GRE protocol.
     */
    public final Integer greKey() {
        return greKey;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(branchInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(trunkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(vlanId());
        hashCode = 31 * hashCode + Objects.hashCode(greKey());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTrunkInterfaceRequest)) {
            return false;
        }
        AssociateTrunkInterfaceRequest other = (AssociateTrunkInterfaceRequest) obj;
        return Objects.equals(branchInterfaceId(), other.branchInterfaceId())
                && Objects.equals(trunkInterfaceId(), other.trunkInterfaceId()) && Objects.equals(vlanId(), other.vlanId())
                && Objects.equals(greKey(), other.greKey()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateTrunkInterfaceRequest").add("BranchInterfaceId", branchInterfaceId())
                .add("TrunkInterfaceId", trunkInterfaceId()).add("VlanId", vlanId()).add("GreKey", greKey())
                .add("ClientToken", clientToken()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BranchInterfaceId":
            return Optional.ofNullable(clazz.cast(branchInterfaceId()));
        case "TrunkInterfaceId":
            return Optional.ofNullable(clazz.cast(trunkInterfaceId()));
        case "VlanId":
            return Optional.ofNullable(clazz.cast(vlanId()));
        case "GreKey":
            return Optional.ofNullable(clazz.cast(greKey()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTrunkInterfaceRequest, T> g) {
        return obj -> g.apply((AssociateTrunkInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateTrunkInterfaceRequest> {
        /**
         * <p>
         * The ID of the branch network interface.
         * </p>
         * 
         * @param branchInterfaceId
         *        The ID of the branch network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchInterfaceId(String branchInterfaceId);

        /**
         * <p>
         * The ID of the trunk network interface.
         * </p>
         * 
         * @param trunkInterfaceId
         *        The ID of the trunk network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trunkInterfaceId(String trunkInterfaceId);

        /**
         * <p>
         * The ID of the VLAN. This applies to the VLAN protocol.
         * </p>
         * 
         * @param vlanId
         *        The ID of the VLAN. This applies to the VLAN protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlanId(Integer vlanId);

        /**
         * <p>
         * The application key. This applies to the GRE protocol.
         * </p>
         * 
         * @param greKey
         *        The application key. This applies to the GRE protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greKey(Integer greKey);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String branchInterfaceId;

        private String trunkInterfaceId;

        private Integer vlanId;

        private Integer greKey;

        private String clientToken;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTrunkInterfaceRequest model) {
            super(model);
            branchInterfaceId(model.branchInterfaceId);
            trunkInterfaceId(model.trunkInterfaceId);
            vlanId(model.vlanId);
            greKey(model.greKey);
            clientToken(model.clientToken);
            dryRun(model.dryRun);
        }

        public final String getBranchInterfaceId() {
            return branchInterfaceId;
        }

        public final void setBranchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
        }

        @Override
        public final Builder branchInterfaceId(String branchInterfaceId) {
            this.branchInterfaceId = branchInterfaceId;
            return this;
        }

        public final String getTrunkInterfaceId() {
            return trunkInterfaceId;
        }

        public final void setTrunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
        }

        @Override
        public final Builder trunkInterfaceId(String trunkInterfaceId) {
            this.trunkInterfaceId = trunkInterfaceId;
            return this;
        }

        public final Integer getVlanId() {
            return vlanId;
        }

        public final void setVlanId(Integer vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public final Builder vlanId(Integer vlanId) {
            this.vlanId = vlanId;
            return this;
        }

        public final Integer getGreKey() {
            return greKey;
        }

        public final void setGreKey(Integer greKey) {
            this.greKey = greKey;
        }

        @Override
        public final Builder greKey(Integer greKey) {
            this.greKey = greKey;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTrunkInterfaceRequest build() {
            return new AssociateTrunkInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
