/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateTransitGatewayPeeringAttachmentRequestOptions;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayPeeringAttachmentRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayPeeringAttachmentRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::transitGatewayId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<String> PEER_TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerTransitGatewayId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerTransitGatewayId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerTransitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerTransitGatewayId").unmarshallLocationName("PeerTransitGatewayId").build()}).build();
    private static final SdkField<String> PEER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAccountId").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerAccountId)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAccountId").unmarshallLocationName("PeerAccountId").build()}).build();
    private static final SdkField<String> PEER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerRegion").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::peerRegion)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::peerRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerRegion").unmarshallLocationName("PeerRegion").build()}).build();
    private static final SdkField<CreateTransitGatewayPeeringAttachmentRequestOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::options)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::options)).constructor(CreateTransitGatewayPeeringAttachmentRequestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("Options").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::tagSpecifications)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateTransitGatewayPeeringAttachmentRequest.getter(CreateTransitGatewayPeeringAttachmentRequest::dryRun)).setter(CreateTransitGatewayPeeringAttachmentRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, PEER_TRANSIT_GATEWAY_ID_FIELD, PEER_ACCOUNT_ID_FIELD, PEER_REGION_FIELD, OPTIONS_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayId", TRANSIT_GATEWAY_ID_FIELD);
            this.put("PeerTransitGatewayId", PEER_TRANSIT_GATEWAY_ID_FIELD);
            this.put("PeerAccountId", PEER_ACCOUNT_ID_FIELD);
            this.put("PeerRegion", PEER_REGION_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
            this.put("DryRun", DRY_RUN_FIELD);
        }
    });
    private final String transitGatewayId;
    private final String peerTransitGatewayId;
    private final String peerAccountId;
    private final String peerRegion;
    private final CreateTransitGatewayPeeringAttachmentRequestOptions options;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;

    private CreateTransitGatewayPeeringAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayId = builder.transitGatewayId;
        this.peerTransitGatewayId = builder.peerTransitGatewayId;
        this.peerAccountId = builder.peerAccountId;
        this.peerRegion = builder.peerRegion;
        this.options = builder.options;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
    }

    public final String transitGatewayId() {
        return this.transitGatewayId;
    }

    public final String peerTransitGatewayId() {
        return this.peerTransitGatewayId;
    }

    public final String peerAccountId() {
        return this.peerAccountId;
    }

    public final String peerRegion() {
        return this.peerRegion;
    }

    public final CreateTransitGatewayPeeringAttachmentRequestOptions options() {
        return this.options;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerTransitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayPeeringAttachmentRequest)) {
            return false;
        }
        CreateTransitGatewayPeeringAttachmentRequest other = (CreateTransitGatewayPeeringAttachmentRequest)((Object)obj);
        return Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.peerTransitGatewayId(), other.peerTransitGatewayId()) && Objects.equals(this.peerAccountId(), other.peerAccountId()) && Objects.equals(this.peerRegion(), other.peerRegion()) && Objects.equals(this.options(), other.options()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayPeeringAttachmentRequest").add("TransitGatewayId", (Object)this.transitGatewayId()).add("PeerTransitGatewayId", (Object)this.peerTransitGatewayId()).add("PeerAccountId", (Object)this.peerAccountId()).add("PeerRegion", (Object)this.peerRegion()).add("Options", (Object)this.options()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "PeerTransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.peerTransitGatewayId()));
            }
            case "PeerAccountId": {
                return Optional.ofNullable(clazz.cast(this.peerAccountId()));
            }
            case "PeerRegion": {
                return Optional.ofNullable(clazz.cast(this.peerRegion()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayPeeringAttachmentRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayPeeringAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayId;
        private String peerTransitGatewayId;
        private String peerAccountId;
        private String peerRegion;
        private CreateTransitGatewayPeeringAttachmentRequestOptions options;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayPeeringAttachmentRequest model) {
            super(model);
            this.transitGatewayId(model.transitGatewayId);
            this.peerTransitGatewayId(model.peerTransitGatewayId);
            this.peerAccountId(model.peerAccountId);
            this.peerRegion(model.peerRegion);
            this.options(model.options);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getPeerTransitGatewayId() {
            return this.peerTransitGatewayId;
        }

        public final void setPeerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
        }

        @Override
        public final Builder peerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
            return this;
        }

        public final String getPeerAccountId() {
            return this.peerAccountId;
        }

        public final void setPeerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
        }

        @Override
        public final Builder peerAccountId(String peerAccountId) {
            this.peerAccountId = peerAccountId;
            return this;
        }

        public final String getPeerRegion() {
            return this.peerRegion;
        }

        public final void setPeerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
        }

        @Override
        public final Builder peerRegion(String peerRegion) {
            this.peerRegion = peerRegion;
            return this;
        }

        public final CreateTransitGatewayPeeringAttachmentRequestOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(CreateTransitGatewayPeeringAttachmentRequestOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(CreateTransitGatewayPeeringAttachmentRequestOptions options) {
            this.options = options;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayPeeringAttachmentRequest build() {
            return new CreateTransitGatewayPeeringAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayPeeringAttachmentRequest> {
        public Builder transitGatewayId(String var1);

        public Builder peerTransitGatewayId(String var1);

        public Builder peerAccountId(String var1);

        public Builder peerRegion(String var1);

        public Builder options(CreateTransitGatewayPeeringAttachmentRequestOptions var1);

        default public Builder options(Consumer<CreateTransitGatewayPeeringAttachmentRequestOptions.Builder> options) {
            return this.options((CreateTransitGatewayPeeringAttachmentRequestOptions)((CreateTransitGatewayPeeringAttachmentRequestOptions.Builder)CreateTransitGatewayPeeringAttachmentRequestOptions.builder().applyMutation(options)).build());
        }

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

