/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindow;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceEventWindowsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceEventWindowsResponse> {
    private static final SdkField<List<InstanceEventWindow>> INSTANCE_EVENT_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceEventWindows").getter(DescribeInstanceEventWindowsResponse.getter(DescribeInstanceEventWindowsResponse::instanceEventWindows)).setter(DescribeInstanceEventWindowsResponse.setter(Builder::instanceEventWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowSet").unmarshallLocationName("instanceEventWindowSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceEventWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceEventWindowsResponse.getter(DescribeInstanceEventWindowsResponse::nextToken)).setter(DescribeInstanceEventWindowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceEventWindowSet", INSTANCE_EVENT_WINDOWS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InstanceEventWindow> instanceEventWindows;
    private final String nextToken;

    private DescribeInstanceEventWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindows = builder.instanceEventWindows;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceEventWindows() {
        return this.instanceEventWindows != null && !(this.instanceEventWindows instanceof SdkAutoConstructList);
    }

    public final List<InstanceEventWindow> instanceEventWindows() {
        return this.instanceEventWindows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceEventWindows() ? this.instanceEventWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceEventWindowsResponse)) {
            return false;
        }
        DescribeInstanceEventWindowsResponse other = (DescribeInstanceEventWindowsResponse)((Object)obj);
        return this.hasInstanceEventWindows() == other.hasInstanceEventWindows() && Objects.equals(this.instanceEventWindows(), other.instanceEventWindows()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceEventWindowsResponse").add("InstanceEventWindows", this.hasInstanceEventWindows() ? this.instanceEventWindows() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventWindows": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceEventWindowsResponse, T> g) {
        return obj -> g.apply((DescribeInstanceEventWindowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceEventWindow> instanceEventWindows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceEventWindowsResponse model) {
            super(model);
            this.instanceEventWindows(model.instanceEventWindows);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceEventWindow.Builder> getInstanceEventWindows() {
            List<InstanceEventWindow.Builder> result = InstanceEventWindowSetCopier.copyToBuilder(this.instanceEventWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceEventWindows(Collection<InstanceEventWindow.BuilderImpl> instanceEventWindows) {
            this.instanceEventWindows = InstanceEventWindowSetCopier.copyFromBuilder(instanceEventWindows);
        }

        @Override
        public final Builder instanceEventWindows(Collection<InstanceEventWindow> instanceEventWindows) {
            this.instanceEventWindows = InstanceEventWindowSetCopier.copy(instanceEventWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceEventWindows(InstanceEventWindow ... instanceEventWindows) {
            this.instanceEventWindows(Arrays.asList(instanceEventWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceEventWindows(Consumer<InstanceEventWindow.Builder> ... instanceEventWindows) {
            this.instanceEventWindows(Stream.of(instanceEventWindows).map(c -> (InstanceEventWindow)((InstanceEventWindow.Builder)InstanceEventWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstanceEventWindowsResponse build() {
            return new DescribeInstanceEventWindowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceEventWindowsResponse> {
        public Builder instanceEventWindows(Collection<InstanceEventWindow> var1);

        public Builder instanceEventWindows(InstanceEventWindow ... var1);

        public Builder instanceEventWindows(Consumer<InstanceEventWindow.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

