/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CoipPool;
import software.amazon.awssdk.services.ec2.model.CoipPoolSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCoipPoolsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCoipPoolsResponse> {
    private static final SdkField<List<CoipPool>> COIP_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CoipPools").getter(DescribeCoipPoolsResponse.getter(DescribeCoipPoolsResponse::coipPools)).setter(DescribeCoipPoolsResponse.setter(Builder::coipPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolSet").unmarshallLocationName("coipPoolSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoipPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCoipPoolsResponse.getter(DescribeCoipPoolsResponse::nextToken)).setter(DescribeCoipPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CoipPoolSet", COIP_POOLS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CoipPool> coipPools;
    private final String nextToken;

    private DescribeCoipPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.coipPools = builder.coipPools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCoipPools() {
        return this.coipPools != null && !(this.coipPools instanceof SdkAutoConstructList);
    }

    public final List<CoipPool> coipPools() {
        return this.coipPools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoipPools() ? this.coipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCoipPoolsResponse)) {
            return false;
        }
        DescribeCoipPoolsResponse other = (DescribeCoipPoolsResponse)((Object)obj);
        return this.hasCoipPools() == other.hasCoipPools() && Objects.equals(this.coipPools(), other.coipPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCoipPoolsResponse").add("CoipPools", this.hasCoipPools() ? this.coipPools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoipPools": {
                return Optional.ofNullable(clazz.cast(this.coipPools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCoipPoolsResponse, T> g) {
        return obj -> g.apply((DescribeCoipPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CoipPool> coipPools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCoipPoolsResponse model) {
            super(model);
            this.coipPools(model.coipPools);
            this.nextToken(model.nextToken);
        }

        public final List<CoipPool.Builder> getCoipPools() {
            List<CoipPool.Builder> result = CoipPoolSetCopier.copyToBuilder(this.coipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoipPools(Collection<CoipPool.BuilderImpl> coipPools) {
            this.coipPools = CoipPoolSetCopier.copyFromBuilder(coipPools);
        }

        @Override
        public final Builder coipPools(Collection<CoipPool> coipPools) {
            this.coipPools = CoipPoolSetCopier.copy(coipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(CoipPool ... coipPools) {
            this.coipPools(Arrays.asList(coipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipPools(Consumer<CoipPool.Builder> ... coipPools) {
            this.coipPools(Stream.of(coipPools).map(c -> (CoipPool)((CoipPool.Builder)CoipPool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCoipPoolsResponse build() {
            return new DescribeCoipPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCoipPoolsResponse> {
        public Builder coipPools(Collection<CoipPool> var1);

        public Builder coipPools(CoipPool ... var1);

        public Builder coipPools(Consumer<CoipPool.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

