/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservation;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationSetCopier;
import software.amazon.awssdk.services.ec2.model.FleetCapacityReservationTenancy;
import software.amazon.awssdk.services.ec2.model.FleetInstanceMatchCriteria;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityReservationFleetResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateCapacityReservationFleetResponse> {
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationFleetId").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::capacityReservationFleetId)).setter(CreateCapacityReservationFleetResponse.setter(Builder::capacityReservationFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId").unmarshallLocationName("capacityReservationFleetId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::stateAsString)).setter(CreateCapacityReservationFleetResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalTargetCapacity").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::totalTargetCapacity)).setter(CreateCapacityReservationFleetResponse.setter(Builder::totalTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity").unmarshallLocationName("totalTargetCapacity").build()}).build();
    private static final SdkField<Double> TOTAL_FULFILLED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalFulfilledCapacity").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::totalFulfilledCapacity)).setter(CreateCapacityReservationFleetResponse.setter(Builder::totalFulfilledCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFulfilledCapacity").unmarshallLocationName("totalFulfilledCapacity").build()}).build();
    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMatchCriteria").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::instanceMatchCriteriaAsString)).setter(CreateCapacityReservationFleetResponse.setter(Builder::instanceMatchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria").unmarshallLocationName("instanceMatchCriteria").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::allocationStrategy)).setter(CreateCapacityReservationFleetResponse.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").unmarshallLocationName("allocationStrategy").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::createTime)).setter(CreateCapacityReservationFleetResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::endDate)).setter(CreateCapacityReservationFleetResponse.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("endDate").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::tenancyAsString)).setter(CreateCapacityReservationFleetResponse.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").unmarshallLocationName("tenancy").build()}).build();
    private static final SdkField<List<FleetCapacityReservation>> FLEET_CAPACITY_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FleetCapacityReservations").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::fleetCapacityReservations)).setter(CreateCapacityReservationFleetResponse.setter(Builder::fleetCapacityReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetCapacityReservationSet").unmarshallLocationName("fleetCapacityReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetCapacityReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCapacityReservationFleetResponse.getter(CreateCapacityReservationFleetResponse::tags)).setter(CreateCapacityReservationFleetResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FLEET_ID_FIELD, STATE_FIELD, TOTAL_TARGET_CAPACITY_FIELD, TOTAL_FULFILLED_CAPACITY_FIELD, INSTANCE_MATCH_CRITERIA_FIELD, ALLOCATION_STRATEGY_FIELD, CREATE_TIME_FIELD, END_DATE_FIELD, TENANCY_FIELD, FLEET_CAPACITY_RESERVATIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CapacityReservationFleetId", CAPACITY_RESERVATION_FLEET_ID_FIELD);
            this.put("State", STATE_FIELD);
            this.put("TotalTargetCapacity", TOTAL_TARGET_CAPACITY_FIELD);
            this.put("TotalFulfilledCapacity", TOTAL_FULFILLED_CAPACITY_FIELD);
            this.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
            this.put("AllocationStrategy", ALLOCATION_STRATEGY_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("EndDate", END_DATE_FIELD);
            this.put("Tenancy", TENANCY_FIELD);
            this.put("FleetCapacityReservationSet", FLEET_CAPACITY_RESERVATIONS_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private final String capacityReservationFleetId;
    private final String state;
    private final Integer totalTargetCapacity;
    private final Double totalFulfilledCapacity;
    private final String instanceMatchCriteria;
    private final String allocationStrategy;
    private final Instant createTime;
    private final Instant endDate;
    private final String tenancy;
    private final List<FleetCapacityReservation> fleetCapacityReservations;
    private final List<Tag> tags;

    private CreateCapacityReservationFleetResponse(BuilderImpl builder) {
        super(builder);
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.state = builder.state;
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.totalFulfilledCapacity = builder.totalFulfilledCapacity;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.allocationStrategy = builder.allocationStrategy;
        this.createTime = builder.createTime;
        this.endDate = builder.endDate;
        this.tenancy = builder.tenancy;
        this.fleetCapacityReservations = builder.fleetCapacityReservations;
        this.tags = builder.tags;
    }

    public final String capacityReservationFleetId() {
        return this.capacityReservationFleetId;
    }

    public final CapacityReservationFleetState state() {
        return CapacityReservationFleetState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public final Double totalFulfilledCapacity() {
        return this.totalFulfilledCapacity;
    }

    public final FleetInstanceMatchCriteria instanceMatchCriteria() {
        return FleetInstanceMatchCriteria.fromValue(this.instanceMatchCriteria);
    }

    public final String instanceMatchCriteriaAsString() {
        return this.instanceMatchCriteria;
    }

    public final String allocationStrategy() {
        return this.allocationStrategy;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final FleetCapacityReservationTenancy tenancy() {
        return FleetCapacityReservationTenancy.fromValue(this.tenancy);
    }

    public final String tenancyAsString() {
        return this.tenancy;
    }

    public final boolean hasFleetCapacityReservations() {
        return this.fleetCapacityReservations != null && !(this.fleetCapacityReservations instanceof SdkAutoConstructList);
    }

    public final List<FleetCapacityReservation> fleetCapacityReservations() {
        return this.fleetCapacityReservations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetCapacityReservations() ? this.fleetCapacityReservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationFleetResponse)) {
            return false;
        }
        CreateCapacityReservationFleetResponse other = (CreateCapacityReservationFleetResponse)((Object)obj);
        return Objects.equals(this.capacityReservationFleetId(), other.capacityReservationFleetId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.totalTargetCapacity(), other.totalTargetCapacity()) && Objects.equals(this.totalFulfilledCapacity(), other.totalFulfilledCapacity()) && Objects.equals(this.instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString()) && Objects.equals(this.allocationStrategy(), other.allocationStrategy()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.tenancyAsString(), other.tenancyAsString()) && this.hasFleetCapacityReservations() == other.hasFleetCapacityReservations() && Objects.equals(this.fleetCapacityReservations(), other.fleetCapacityReservations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapacityReservationFleetResponse").add("CapacityReservationFleetId", (Object)this.capacityReservationFleetId()).add("State", (Object)this.stateAsString()).add("TotalTargetCapacity", (Object)this.totalTargetCapacity()).add("TotalFulfilledCapacity", (Object)this.totalFulfilledCapacity()).add("InstanceMatchCriteria", (Object)this.instanceMatchCriteriaAsString()).add("AllocationStrategy", (Object)this.allocationStrategy()).add("CreateTime", (Object)this.createTime()).add("EndDate", (Object)this.endDate()).add("Tenancy", (Object)this.tenancyAsString()).add("FleetCapacityReservations", this.hasFleetCapacityReservations() ? this.fleetCapacityReservations() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationFleetId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleetId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "TotalTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalTargetCapacity()));
            }
            case "TotalFulfilledCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalFulfilledCapacity()));
            }
            case "InstanceMatchCriteria": {
                return Optional.ofNullable(clazz.cast(this.instanceMatchCriteriaAsString()));
            }
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategy()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancyAsString()));
            }
            case "FleetCapacityReservations": {
                return Optional.ofNullable(clazz.cast(this.fleetCapacityReservations()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationFleetResponse, T> g) {
        return obj -> g.apply((CreateCapacityReservationFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String capacityReservationFleetId;
        private String state;
        private Integer totalTargetCapacity;
        private Double totalFulfilledCapacity;
        private String instanceMatchCriteria;
        private String allocationStrategy;
        private Instant createTime;
        private Instant endDate;
        private String tenancy;
        private List<FleetCapacityReservation> fleetCapacityReservations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationFleetResponse model) {
            super(model);
            this.capacityReservationFleetId(model.capacityReservationFleetId);
            this.state(model.state);
            this.totalTargetCapacity(model.totalTargetCapacity);
            this.totalFulfilledCapacity(model.totalFulfilledCapacity);
            this.instanceMatchCriteria(model.instanceMatchCriteria);
            this.allocationStrategy(model.allocationStrategy);
            this.createTime(model.createTime);
            this.endDate(model.endDate);
            this.tenancy(model.tenancy);
            this.fleetCapacityReservations(model.fleetCapacityReservations);
            this.tags(model.tags);
        }

        public final String getCapacityReservationFleetId() {
            return this.capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityReservationFleetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Double getTotalFulfilledCapacity() {
            return this.totalFulfilledCapacity;
        }

        public final void setTotalFulfilledCapacity(Double totalFulfilledCapacity) {
            this.totalFulfilledCapacity = totalFulfilledCapacity;
        }

        @Override
        public final Builder totalFulfilledCapacity(Double totalFulfilledCapacity) {
            this.totalFulfilledCapacity = totalFulfilledCapacity;
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return this.instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(FleetInstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(FleetCapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final List<FleetCapacityReservation.Builder> getFleetCapacityReservations() {
            List<FleetCapacityReservation.Builder> result = FleetCapacityReservationSetCopier.copyToBuilder(this.fleetCapacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetCapacityReservations(Collection<FleetCapacityReservation.BuilderImpl> fleetCapacityReservations) {
            this.fleetCapacityReservations = FleetCapacityReservationSetCopier.copyFromBuilder(fleetCapacityReservations);
        }

        @Override
        public final Builder fleetCapacityReservations(Collection<FleetCapacityReservation> fleetCapacityReservations) {
            this.fleetCapacityReservations = FleetCapacityReservationSetCopier.copy(fleetCapacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacityReservations(FleetCapacityReservation ... fleetCapacityReservations) {
            this.fleetCapacityReservations(Arrays.asList(fleetCapacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetCapacityReservations(Consumer<FleetCapacityReservation.Builder> ... fleetCapacityReservations) {
            this.fleetCapacityReservations(Stream.of(fleetCapacityReservations).map(c -> (FleetCapacityReservation)((FleetCapacityReservation.Builder)FleetCapacityReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateCapacityReservationFleetResponse build() {
            return new CreateCapacityReservationFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityReservationFleetResponse> {
        public Builder capacityReservationFleetId(String var1);

        public Builder state(String var1);

        public Builder state(CapacityReservationFleetState var1);

        public Builder totalTargetCapacity(Integer var1);

        public Builder totalFulfilledCapacity(Double var1);

        public Builder instanceMatchCriteria(String var1);

        public Builder instanceMatchCriteria(FleetInstanceMatchCriteria var1);

        public Builder allocationStrategy(String var1);

        public Builder createTime(Instant var1);

        public Builder endDate(Instant var1);

        public Builder tenancy(String var1);

        public Builder tenancy(FleetCapacityReservationTenancy var1);

        public Builder fleetCapacityReservations(Collection<FleetCapacityReservation> var1);

        public Builder fleetCapacityReservations(FleetCapacityReservation ... var1);

        public Builder fleetCapacityReservations(Consumer<FleetCapacityReservation.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

