/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventCode {
    INSTANCE_REBOOT("instance-reboot"),
    SYSTEM_REBOOT("system-reboot"),
    SYSTEM_MAINTENANCE("system-maintenance"),
    INSTANCE_RETIREMENT("instance-retirement"),
    INSTANCE_STOP("instance-stop"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventCode> VALUE_MAP;
    private final String value;

    private EventCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventCode> knownValues() {
        EnumSet<EventCode> knownValues = EnumSet.allOf(EventCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventCode.class, EventCode::toString);
    }
}

