/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubnetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSubnetRequest> {
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateSubnetRequest.getter(CreateSubnetRequest::tagSpecifications)).setter(CreateSubnetRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateSubnetRequest.getter(CreateSubnetRequest::availabilityZone)).setter(CreateSubnetRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(CreateSubnetRequest.getter(CreateSubnetRequest::availabilityZoneId)).setter(CreateSubnetRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("AvailabilityZoneId").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(CreateSubnetRequest.getter(CreateSubnetRequest::cidrBlock)).setter(CreateSubnetRequest.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("CidrBlock").build()}).build();
    private static final SdkField<String> IPV6_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6CidrBlock").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv6CidrBlock)).setter(CreateSubnetRequest.setter(Builder::ipv6CidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlock").unmarshallLocationName("Ipv6CidrBlock").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(CreateSubnetRequest.getter(CreateSubnetRequest::outpostArn)).setter(CreateSubnetRequest.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("OutpostArn").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(CreateSubnetRequest.getter(CreateSubnetRequest::vpcId)).setter(CreateSubnetRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("VpcId").build()}).build();
    private static final SdkField<Boolean> IPV6_NATIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Native").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv6Native)).setter(CreateSubnetRequest.setter(Builder::ipv6Native)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Native").unmarshallLocationName("Ipv6Native").build()}).build();
    private static final SdkField<String> IPV4_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv4IpamPoolId").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv4IpamPoolId)).setter(CreateSubnetRequest.setter(Builder::ipv4IpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4IpamPoolId").unmarshallLocationName("Ipv4IpamPoolId").build()}).build();
    private static final SdkField<Integer> IPV4_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv4NetmaskLength").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv4NetmaskLength)).setter(CreateSubnetRequest.setter(Builder::ipv4NetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4NetmaskLength").unmarshallLocationName("Ipv4NetmaskLength").build()}).build();
    private static final SdkField<String> IPV6_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6IpamPoolId").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv6IpamPoolId)).setter(CreateSubnetRequest.setter(Builder::ipv6IpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6IpamPoolId").unmarshallLocationName("Ipv6IpamPoolId").build()}).build();
    private static final SdkField<Integer> IPV6_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6NetmaskLength").getter(CreateSubnetRequest.getter(CreateSubnetRequest::ipv6NetmaskLength)).setter(CreateSubnetRequest.setter(Builder::ipv6NetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6NetmaskLength").unmarshallLocationName("Ipv6NetmaskLength").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateSubnetRequest.getter(CreateSubnetRequest::dryRun)).setter(CreateSubnetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SPECIFICATIONS_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_FIELD, OUTPOST_ARN_FIELD, VPC_ID_FIELD, IPV6_NATIVE_FIELD, IPV4_IPAM_POOL_ID_FIELD, IPV4_NETMASK_LENGTH_FIELD, IPV6_IPAM_POOL_ID_FIELD, IPV6_NETMASK_LENGTH_FIELD, DRY_RUN_FIELD));
    private final List<TagSpecification> tagSpecifications;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String cidrBlock;
    private final String ipv6CidrBlock;
    private final String outpostArn;
    private final String vpcId;
    private final Boolean ipv6Native;
    private final String ipv4IpamPoolId;
    private final Integer ipv4NetmaskLength;
    private final String ipv6IpamPoolId;
    private final Integer ipv6NetmaskLength;
    private final Boolean dryRun;

    private CreateSubnetRequest(BuilderImpl builder) {
        super(builder);
        this.tagSpecifications = builder.tagSpecifications;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.outpostArn = builder.outpostArn;
        this.vpcId = builder.vpcId;
        this.ipv6Native = builder.ipv6Native;
        this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
        this.ipv4NetmaskLength = builder.ipv4NetmaskLength;
        this.ipv6IpamPoolId = builder.ipv6IpamPoolId;
        this.ipv6NetmaskLength = builder.ipv6NetmaskLength;
        this.dryRun = builder.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Boolean ipv6Native() {
        return this.ipv6Native;
    }

    public final String ipv4IpamPoolId() {
        return this.ipv4IpamPoolId;
    }

    public final Integer ipv4NetmaskLength() {
        return this.ipv4NetmaskLength;
    }

    public final String ipv6IpamPoolId() {
        return this.ipv6IpamPoolId;
    }

    public final Integer ipv6NetmaskLength() {
        return this.ipv6NetmaskLength;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Native());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6IpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6NetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest)((Object)obj);
        return this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ipv6Native(), other.ipv6Native()) && Objects.equals(this.ipv4IpamPoolId(), other.ipv4IpamPoolId()) && Objects.equals(this.ipv4NetmaskLength(), other.ipv4NetmaskLength()) && Objects.equals(this.ipv6IpamPoolId(), other.ipv6IpamPoolId()) && Objects.equals(this.ipv6NetmaskLength(), other.ipv6NetmaskLength()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubnetRequest").add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("OutpostArn", (Object)this.outpostArn()).add("VpcId", (Object)this.vpcId()).add("Ipv6Native", (Object)this.ipv6Native()).add("Ipv4IpamPoolId", (Object)this.ipv4IpamPoolId()).add("Ipv4NetmaskLength", (Object)this.ipv4NetmaskLength()).add("Ipv6IpamPoolId", (Object)this.ipv6IpamPoolId()).add("Ipv6NetmaskLength", (Object)this.ipv6NetmaskLength()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlock()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Ipv6Native": {
                return Optional.ofNullable(clazz.cast(this.ipv6Native()));
            }
            case "Ipv4IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipv4IpamPoolId()));
            }
            case "Ipv4NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.ipv4NetmaskLength()));
            }
            case "Ipv6IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipv6IpamPoolId()));
            }
            case "Ipv6NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.ipv6NetmaskLength()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetRequest, T> g) {
        return obj -> g.apply((CreateSubnetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String availabilityZoneId;
        private String cidrBlock;
        private String ipv6CidrBlock;
        private String outpostArn;
        private String vpcId;
        private Boolean ipv6Native;
        private String ipv4IpamPoolId;
        private Integer ipv4NetmaskLength;
        private String ipv6IpamPoolId;
        private Integer ipv6NetmaskLength;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetRequest model) {
            super(model);
            this.tagSpecifications(model.tagSpecifications);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.outpostArn(model.outpostArn);
            this.vpcId(model.vpcId);
            this.ipv6Native(model.ipv6Native);
            this.ipv4IpamPoolId(model.ipv4IpamPoolId);
            this.ipv4NetmaskLength(model.ipv4NetmaskLength);
            this.ipv6IpamPoolId(model.ipv6IpamPoolId);
            this.ipv6NetmaskLength(model.ipv6NetmaskLength);
            this.dryRun(model.dryRun);
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getIpv6Native() {
            return this.ipv6Native;
        }

        public final void setIpv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
        }

        @Override
        public final Builder ipv6Native(Boolean ipv6Native) {
            this.ipv6Native = ipv6Native;
            return this;
        }

        public final String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        public final void setIpv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
        }

        @Override
        public final Builder ipv4IpamPoolId(String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        public final Integer getIpv4NetmaskLength() {
            return this.ipv4NetmaskLength;
        }

        public final void setIpv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
        }

        @Override
        public final Builder ipv4NetmaskLength(Integer ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        public final String getIpv6IpamPoolId() {
            return this.ipv6IpamPoolId;
        }

        public final void setIpv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
        }

        @Override
        public final Builder ipv6IpamPoolId(String ipv6IpamPoolId) {
            this.ipv6IpamPoolId = ipv6IpamPoolId;
            return this;
        }

        public final Integer getIpv6NetmaskLength() {
            return this.ipv6NetmaskLength;
        }

        public final void setIpv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
        }

        @Override
        public final Builder ipv6NetmaskLength(Integer ipv6NetmaskLength) {
            this.ipv6NetmaskLength = ipv6NetmaskLength;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetRequest build() {
            return new CreateSubnetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubnetRequest> {
        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder outpostArn(String var1);

        public Builder vpcId(String var1);

        public Builder ipv6Native(Boolean var1);

        public Builder ipv4IpamPoolId(String var1);

        public Builder ipv4NetmaskLength(Integer var1);

        public Builder ipv6IpamPoolId(String var1);

        public Builder ipv6NetmaskLength(Integer var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

