/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCpuOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyInstanceCpuOptionsResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceCpuOptionsResponse.getter(ModifyInstanceCpuOptionsResponse::instanceId)).setter(ModifyInstanceCpuOptionsResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CoreCount").getter(ModifyInstanceCpuOptionsResponse.getter(ModifyInstanceCpuOptionsResponse::coreCount)).setter(ModifyInstanceCpuOptionsResponse.setter(Builder::coreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount").unmarshallLocationName("coreCount").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ModifyInstanceCpuOptionsResponse.getter(ModifyInstanceCpuOptionsResponse::threadsPerCore)).setter(ModifyInstanceCpuOptionsResponse.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").unmarshallLocationName("threadsPerCore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CORE_COUNT_FIELD, THREADS_PER_CORE_FIELD));
    private final String instanceId;
    private final Integer coreCount;
    private final Integer threadsPerCore;

    private ModifyInstanceCpuOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Integer coreCount() {
        return this.coreCount;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCpuOptionsResponse)) {
            return false;
        }
        ModifyInstanceCpuOptionsResponse other = (ModifyInstanceCpuOptionsResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.coreCount(), other.coreCount()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceCpuOptionsResponse").add("InstanceId", (Object)this.instanceId()).add("CoreCount", (Object)this.coreCount()).add("ThreadsPerCore", (Object)this.threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CoreCount": {
                return Optional.ofNullable(clazz.cast(this.coreCount()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCpuOptionsResponse, T> g) {
        return obj -> g.apply((ModifyInstanceCpuOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private Integer coreCount;
        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCpuOptionsResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.coreCount(model.coreCount);
            this.threadsPerCore(model.threadsPerCore);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Integer getCoreCount() {
            return this.coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public ModifyInstanceCpuOptionsResponse build() {
            return new ModifyInstanceCpuOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceCpuOptionsResponse> {
        public Builder instanceId(String var1);

        public Builder coreCount(Integer var1);

        public Builder threadsPerCore(Integer var1);
    }
}

