/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DefaultInstanceMetadataEndpointState;
import software.amazon.awssdk.services.ec2.model.DefaultInstanceMetadataTagsState;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.MetadataDefaultHttpTokensState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceMetadataDefaultsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceMetadataDefaultsRequest> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(ModifyInstanceMetadataDefaultsRequest.getter(ModifyInstanceMetadataDefaultsRequest::httpTokensAsString)).setter(ModifyInstanceMetadataDefaultsRequest.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").unmarshallLocationName("HttpTokens").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(ModifyInstanceMetadataDefaultsRequest.getter(ModifyInstanceMetadataDefaultsRequest::httpPutResponseHopLimit)).setter(ModifyInstanceMetadataDefaultsRequest.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").unmarshallLocationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(ModifyInstanceMetadataDefaultsRequest.getter(ModifyInstanceMetadataDefaultsRequest::httpEndpointAsString)).setter(ModifyInstanceMetadataDefaultsRequest.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").unmarshallLocationName("HttpEndpoint").build()}).build();
    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMetadataTags").getter(ModifyInstanceMetadataDefaultsRequest.getter(ModifyInstanceMetadataDefaultsRequest::instanceMetadataTagsAsString)).setter(ModifyInstanceMetadataDefaultsRequest.setter(Builder::instanceMetadataTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").unmarshallLocationName("InstanceMetadataTags").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyInstanceMetadataDefaultsRequest.getter(ModifyInstanceMetadataDefaultsRequest::dryRun)).setter(ModifyInstanceMetadataDefaultsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD, INSTANCE_METADATA_TAGS_FIELD, DRY_RUN_FIELD));
    private final String httpTokens;
    private final Integer httpPutResponseHopLimit;
    private final String httpEndpoint;
    private final String instanceMetadataTags;
    private final Boolean dryRun;

    private ModifyInstanceMetadataDefaultsRequest(BuilderImpl builder) {
        super(builder);
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
        this.instanceMetadataTags = builder.instanceMetadataTags;
        this.dryRun = builder.dryRun;
    }

    public final MetadataDefaultHttpTokensState httpTokens() {
        return MetadataDefaultHttpTokensState.fromValue(this.httpTokens);
    }

    public final String httpTokensAsString() {
        return this.httpTokens;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final DefaultInstanceMetadataEndpointState httpEndpoint() {
        return DefaultInstanceMetadataEndpointState.fromValue(this.httpEndpoint);
    }

    public final String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public final DefaultInstanceMetadataTagsState instanceMetadataTags() {
        return DefaultInstanceMetadataTagsState.fromValue(this.instanceMetadataTags);
    }

    public final String instanceMetadataTagsAsString() {
        return this.instanceMetadataTags;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceMetadataDefaultsRequest)) {
            return false;
        }
        ModifyInstanceMetadataDefaultsRequest other = (ModifyInstanceMetadataDefaultsRequest)((Object)obj);
        return Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString()) && Objects.equals(this.instanceMetadataTagsAsString(), other.instanceMetadataTagsAsString()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceMetadataDefaultsRequest").add("HttpTokens", (Object)this.httpTokensAsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpEndpoint", (Object)this.httpEndpointAsString()).add("InstanceMetadataTags", (Object)this.instanceMetadataTagsAsString()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
            case "InstanceMetadataTags": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataTagsAsString()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceMetadataDefaultsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceMetadataDefaultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String httpTokens;
        private Integer httpPutResponseHopLimit;
        private String httpEndpoint;
        private String instanceMetadataTags;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceMetadataDefaultsRequest model) {
            super(model);
            this.httpTokens(model.httpTokens);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpEndpoint(model.httpEndpoint);
            this.instanceMetadataTags(model.instanceMetadataTags);
            this.dryRun(model.dryRun);
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(MetadataDefaultHttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(DefaultInstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public final Builder instanceMetadataTags(DefaultInstanceMetadataTagsState instanceMetadataTags) {
            this.instanceMetadataTags(instanceMetadataTags == null ? null : instanceMetadataTags.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceMetadataDefaultsRequest build() {
            return new ModifyInstanceMetadataDefaultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceMetadataDefaultsRequest> {
        public Builder httpTokens(String var1);

        public Builder httpTokens(MetadataDefaultHttpTokensState var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(DefaultInstanceMetadataEndpointState var1);

        public Builder instanceMetadataTags(String var1);

        public Builder instanceMetadataTags(DefaultInstanceMetadataTagsState var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

