/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessGroupResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyVerifiedAccessGroupResponse.Builder, ModifyVerifiedAccessGroupResponse> {
    private static final SdkField<VerifiedAccessGroup> VERIFIED_ACCESS_GROUP_FIELD = SdkField
            .<VerifiedAccessGroup> builder(MarshallingType.SDK_POJO)
            .memberName("VerifiedAccessGroup")
            .getter(getter(ModifyVerifiedAccessGroupResponse::verifiedAccessGroup))
            .setter(setter(Builder::verifiedAccessGroup))
            .constructor(VerifiedAccessGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroup")
                    .unmarshallLocationName("verifiedAccessGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUP_FIELD));

    private final VerifiedAccessGroup verifiedAccessGroup;

    private ModifyVerifiedAccessGroupResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessGroup = builder.verifiedAccessGroup;
    }

    /**
     * <p>
     * Details about the Verified Access group.
     * </p>
     * 
     * @return Details about the Verified Access group.
     */
    public final VerifiedAccessGroup verifiedAccessGroup() {
        return verifiedAccessGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessGroupResponse)) {
            return false;
        }
        ModifyVerifiedAccessGroupResponse other = (ModifyVerifiedAccessGroupResponse) obj;
        return Objects.equals(verifiedAccessGroup(), other.verifiedAccessGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessGroupResponse").add("VerifiedAccessGroup", verifiedAccessGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessGroup":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessGroupResponse, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVerifiedAccessGroupResponse> {
        /**
         * <p>
         * Details about the Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroup
         *        Details about the Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroup(VerifiedAccessGroup verifiedAccessGroup);

        /**
         * <p>
         * Details about the Verified Access group.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessGroup.Builder} avoiding the
         * need to create one manually via {@link VerifiedAccessGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #verifiedAccessGroup(VerifiedAccessGroup)}.
         * 
         * @param verifiedAccessGroup
         *        a consumer that will call methods on {@link VerifiedAccessGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessGroup(VerifiedAccessGroup)
         */
        default Builder verifiedAccessGroup(Consumer<VerifiedAccessGroup.Builder> verifiedAccessGroup) {
            return verifiedAccessGroup(VerifiedAccessGroup.builder().applyMutation(verifiedAccessGroup).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VerifiedAccessGroup verifiedAccessGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessGroupResponse model) {
            super(model);
            verifiedAccessGroup(model.verifiedAccessGroup);
        }

        public final VerifiedAccessGroup.Builder getVerifiedAccessGroup() {
            return verifiedAccessGroup != null ? verifiedAccessGroup.toBuilder() : null;
        }

        public final void setVerifiedAccessGroup(VerifiedAccessGroup.BuilderImpl verifiedAccessGroup) {
            this.verifiedAccessGroup = verifiedAccessGroup != null ? verifiedAccessGroup.build() : null;
        }

        @Override
        public final Builder verifiedAccessGroup(VerifiedAccessGroup verifiedAccessGroup) {
            this.verifiedAccessGroup = verifiedAccessGroup;
            return this;
        }

        @Override
        public ModifyVerifiedAccessGroupResponse build() {
            return new ModifyVerifiedAccessGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
