/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;

public class DescribeStaleSecurityGroupsPublisher
implements SdkPublisher<DescribeStaleSecurityGroupsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeStaleSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStaleSecurityGroupsPublisher(Ec2AsyncClient client, DescribeStaleSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStaleSecurityGroupsPublisher(Ec2AsyncClient client, DescribeStaleSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStaleSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStaleSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StaleSecurityGroup> staleSecurityGroupSet() {
        Function<DescribeStaleSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.staleSecurityGroupSet() != null) {
                return response.staleSecurityGroupSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStaleSecurityGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStaleSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeStaleSecurityGroupsResponse> {
        private DescribeStaleSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStaleSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStaleSecurityGroupsResponse> nextPage(DescribeStaleSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStaleSecurityGroupsPublisher.this.client.describeStaleSecurityGroups(DescribeStaleSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeStaleSecurityGroupsPublisher.this.client.describeStaleSecurityGroups((DescribeStaleSecurityGroupsRequest)((Object)DescribeStaleSecurityGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

