/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateClientVpnTargetNetworkRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateClientVpnTargetNetworkRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(AssociateClientVpnTargetNetworkRequest.getter(AssociateClientVpnTargetNetworkRequest::clientVpnEndpointId)).setter(AssociateClientVpnTargetNetworkRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(AssociateClientVpnTargetNetworkRequest.getter(AssociateClientVpnTargetNetworkRequest::subnetId)).setter(AssociateClientVpnTargetNetworkRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AssociateClientVpnTargetNetworkRequest.getter(AssociateClientVpnTargetNetworkRequest::clientToken)).setter(AssociateClientVpnTargetNetworkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(AssociateClientVpnTargetNetworkRequest.getter(AssociateClientVpnTargetNetworkRequest::dryRun)).setter(AssociateClientVpnTargetNetworkRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, SUBNET_ID_FIELD, CLIENT_TOKEN_FIELD, DRY_RUN_FIELD));
    private final String clientVpnEndpointId;
    private final String subnetId;
    private final String clientToken;
    private final Boolean dryRun;

    private AssociateClientVpnTargetNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.subnetId = builder.subnetId;
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateClientVpnTargetNetworkRequest)) {
            return false;
        }
        AssociateClientVpnTargetNetworkRequest other = (AssociateClientVpnTargetNetworkRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateClientVpnTargetNetworkRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("SubnetId", (Object)this.subnetId()).add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateClientVpnTargetNetworkRequest, T> g) {
        return obj -> g.apply((AssociateClientVpnTargetNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String subnetId;
        private String clientToken;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateClientVpnTargetNetworkRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.subnetId(model.subnetId);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateClientVpnTargetNetworkRequest build() {
            return new AssociateClientVpnTargetNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateClientVpnTargetNetworkRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder subnetId(String var1);

        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

