/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, TerminateInstancesResponse> {
    private static final SdkField<List<InstanceStateChange>> TERMINATING_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminatingInstances").getter(TerminateInstancesResponse.getter(TerminateInstancesResponse::terminatingInstances)).setter(TerminateInstancesResponse.setter(Builder::terminatingInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesSet").unmarshallLocationName("instancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINATING_INSTANCES_FIELD));
    private final List<InstanceStateChange> terminatingInstances;

    private TerminateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.terminatingInstances = builder.terminatingInstances;
    }

    public final boolean hasTerminatingInstances() {
        return this.terminatingInstances != null && !(this.terminatingInstances instanceof SdkAutoConstructList);
    }

    public final List<InstanceStateChange> terminatingInstances() {
        return this.terminatingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminatingInstances() ? this.terminatingInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstancesResponse)) {
            return false;
        }
        TerminateInstancesResponse other = (TerminateInstancesResponse)((Object)obj);
        return this.hasTerminatingInstances() == other.hasTerminatingInstances() && Objects.equals(this.terminatingInstances(), other.terminatingInstances());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateInstancesResponse").add("TerminatingInstances", this.hasTerminatingInstances() ? this.terminatingInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminatingInstances": {
                return Optional.ofNullable(clazz.cast(this.terminatingInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateInstancesResponse, T> g) {
        return obj -> g.apply((TerminateInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> terminatingInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstancesResponse model) {
            super(model);
            this.terminatingInstances(model.terminatingInstances);
        }

        public final List<InstanceStateChange.Builder> getTerminatingInstances() {
            List<InstanceStateChange.Builder> result = InstanceStateChangeListCopier.copyToBuilder(this.terminatingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerminatingInstances(Collection<InstanceStateChange.BuilderImpl> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copyFromBuilder(terminatingInstances);
        }

        @Override
        public final Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copy(terminatingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(InstanceStateChange ... terminatingInstances) {
            this.terminatingInstances(Arrays.asList(terminatingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(Consumer<InstanceStateChange.Builder> ... terminatingInstances) {
            this.terminatingInstances(Stream.of(terminatingInstances).map(c -> (InstanceStateChange)((InstanceStateChange.Builder)InstanceStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TerminateInstancesResponse build() {
            return new TerminateInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateInstancesResponse> {
        public Builder terminatingInstances(Collection<InstanceStateChange> var1);

        public Builder terminatingInstances(InstanceStateChange ... var1);

        public Builder terminatingInstances(Consumer<InstanceStateChange.Builder> ... var1);
    }
}

