/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpamPoolRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyIpamPoolRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::dryRun)).setter(ModifyIpamPoolRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::ipamPoolId)).setter(ModifyIpamPoolRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::description)).setter(ModifyIpamPoolRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> AUTO_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoImport").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::autoImport)).setter(ModifyIpamPoolRequest.setter(Builder::autoImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImport").unmarshallLocationName("AutoImport").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MIN_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMinNetmaskLength").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::allocationMinNetmaskLength)).setter(ModifyIpamPoolRequest.setter(Builder::allocationMinNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMinNetmaskLength").unmarshallLocationName("AllocationMinNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MAX_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMaxNetmaskLength").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::allocationMaxNetmaskLength)).setter(ModifyIpamPoolRequest.setter(Builder::allocationMaxNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMaxNetmaskLength").unmarshallLocationName("AllocationMaxNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationDefaultNetmaskLength").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::allocationDefaultNetmaskLength)).setter(ModifyIpamPoolRequest.setter(Builder::allocationDefaultNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationDefaultNetmaskLength").unmarshallLocationName("AllocationDefaultNetmaskLength").build()}).build();
    private static final SdkField<Boolean> CLEAR_ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClearAllocationDefaultNetmaskLength").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::clearAllocationDefaultNetmaskLength)).setter(ModifyIpamPoolRequest.setter(Builder::clearAllocationDefaultNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClearAllocationDefaultNetmaskLength").unmarshallLocationName("ClearAllocationDefaultNetmaskLength").build()}).build();
    private static final SdkField<List<RequestIpamResourceTag>> ADD_ALLOCATION_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddAllocationResourceTags").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::addAllocationResourceTags)).setter(ModifyIpamPoolRequest.setter(Builder::addAllocationResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddAllocationResourceTag").unmarshallLocationName("AddAllocationResourceTag").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestIpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<RequestIpamResourceTag>> REMOVE_ALLOCATION_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveAllocationResourceTags").getter(ModifyIpamPoolRequest.getter(ModifyIpamPoolRequest::removeAllocationResourceTags)).setter(ModifyIpamPoolRequest.setter(Builder::removeAllocationResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllocationResourceTag").unmarshallLocationName("RemoveAllocationResourceTag").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestIpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_POOL_ID_FIELD, DESCRIPTION_FIELD, AUTO_IMPORT_FIELD, ALLOCATION_MIN_NETMASK_LENGTH_FIELD, ALLOCATION_MAX_NETMASK_LENGTH_FIELD, ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD, CLEAR_ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD, ADD_ALLOCATION_RESOURCE_TAGS_FIELD, REMOVE_ALLOCATION_RESOURCE_TAGS_FIELD));
    private final Boolean dryRun;
    private final String ipamPoolId;
    private final String description;
    private final Boolean autoImport;
    private final Integer allocationMinNetmaskLength;
    private final Integer allocationMaxNetmaskLength;
    private final Integer allocationDefaultNetmaskLength;
    private final Boolean clearAllocationDefaultNetmaskLength;
    private final List<RequestIpamResourceTag> addAllocationResourceTags;
    private final List<RequestIpamResourceTag> removeAllocationResourceTags;

    private ModifyIpamPoolRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.description = builder.description;
        this.autoImport = builder.autoImport;
        this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
        this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
        this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
        this.clearAllocationDefaultNetmaskLength = builder.clearAllocationDefaultNetmaskLength;
        this.addAllocationResourceTags = builder.addAllocationResourceTags;
        this.removeAllocationResourceTags = builder.removeAllocationResourceTags;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean autoImport() {
        return this.autoImport;
    }

    public final Integer allocationMinNetmaskLength() {
        return this.allocationMinNetmaskLength;
    }

    public final Integer allocationMaxNetmaskLength() {
        return this.allocationMaxNetmaskLength;
    }

    public final Integer allocationDefaultNetmaskLength() {
        return this.allocationDefaultNetmaskLength;
    }

    public final Boolean clearAllocationDefaultNetmaskLength() {
        return this.clearAllocationDefaultNetmaskLength;
    }

    public final boolean hasAddAllocationResourceTags() {
        return this.addAllocationResourceTags != null && !(this.addAllocationResourceTags instanceof SdkAutoConstructList);
    }

    public final List<RequestIpamResourceTag> addAllocationResourceTags() {
        return this.addAllocationResourceTags;
    }

    public final boolean hasRemoveAllocationResourceTags() {
        return this.removeAllocationResourceTags != null && !(this.removeAllocationResourceTags instanceof SdkAutoConstructList);
    }

    public final List<RequestIpamResourceTag> removeAllocationResourceTags() {
        return this.removeAllocationResourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMinNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMaxNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.clearAllocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddAllocationResourceTags() ? this.addAllocationResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveAllocationResourceTags() ? this.removeAllocationResourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPoolRequest)) {
            return false;
        }
        ModifyIpamPoolRequest other = (ModifyIpamPoolRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoImport(), other.autoImport()) && Objects.equals(this.allocationMinNetmaskLength(), other.allocationMinNetmaskLength()) && Objects.equals(this.allocationMaxNetmaskLength(), other.allocationMaxNetmaskLength()) && Objects.equals(this.allocationDefaultNetmaskLength(), other.allocationDefaultNetmaskLength()) && Objects.equals(this.clearAllocationDefaultNetmaskLength(), other.clearAllocationDefaultNetmaskLength()) && this.hasAddAllocationResourceTags() == other.hasAddAllocationResourceTags() && Objects.equals(this.addAllocationResourceTags(), other.addAllocationResourceTags()) && this.hasRemoveAllocationResourceTags() == other.hasRemoveAllocationResourceTags() && Objects.equals(this.removeAllocationResourceTags(), other.removeAllocationResourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpamPoolRequest").add("DryRun", (Object)this.dryRun()).add("IpamPoolId", (Object)this.ipamPoolId()).add("Description", (Object)this.description()).add("AutoImport", (Object)this.autoImport()).add("AllocationMinNetmaskLength", (Object)this.allocationMinNetmaskLength()).add("AllocationMaxNetmaskLength", (Object)this.allocationMaxNetmaskLength()).add("AllocationDefaultNetmaskLength", (Object)this.allocationDefaultNetmaskLength()).add("ClearAllocationDefaultNetmaskLength", (Object)this.clearAllocationDefaultNetmaskLength()).add("AddAllocationResourceTags", this.hasAddAllocationResourceTags() ? this.addAllocationResourceTags() : null).add("RemoveAllocationResourceTags", this.hasRemoveAllocationResourceTags() ? this.removeAllocationResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AutoImport": {
                return Optional.ofNullable(clazz.cast(this.autoImport()));
            }
            case "AllocationMinNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMinNetmaskLength()));
            }
            case "AllocationMaxNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMaxNetmaskLength()));
            }
            case "AllocationDefaultNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationDefaultNetmaskLength()));
            }
            case "ClearAllocationDefaultNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.clearAllocationDefaultNetmaskLength()));
            }
            case "AddAllocationResourceTags": {
                return Optional.ofNullable(clazz.cast(this.addAllocationResourceTags()));
            }
            case "RemoveAllocationResourceTags": {
                return Optional.ofNullable(clazz.cast(this.removeAllocationResourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpamPoolRequest, T> g) {
        return obj -> g.apply((ModifyIpamPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPoolId;
        private String description;
        private Boolean autoImport;
        private Integer allocationMinNetmaskLength;
        private Integer allocationMaxNetmaskLength;
        private Integer allocationDefaultNetmaskLength;
        private Boolean clearAllocationDefaultNetmaskLength;
        private List<RequestIpamResourceTag> addAllocationResourceTags = DefaultSdkAutoConstructList.getInstance();
        private List<RequestIpamResourceTag> removeAllocationResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpamPoolRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPoolId(model.ipamPoolId);
            this.description(model.description);
            this.autoImport(model.autoImport);
            this.allocationMinNetmaskLength(model.allocationMinNetmaskLength);
            this.allocationMaxNetmaskLength(model.allocationMaxNetmaskLength);
            this.allocationDefaultNetmaskLength(model.allocationDefaultNetmaskLength);
            this.clearAllocationDefaultNetmaskLength(model.clearAllocationDefaultNetmaskLength);
            this.addAllocationResourceTags(model.addAllocationResourceTags);
            this.removeAllocationResourceTags(model.removeAllocationResourceTags);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoImport() {
            return this.autoImport;
        }

        public final void setAutoImport(Boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public final Builder autoImport(Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        public final Integer getAllocationMinNetmaskLength() {
            return this.allocationMinNetmaskLength;
        }

        public final void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
        }

        @Override
        public final Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        public final Integer getAllocationMaxNetmaskLength() {
            return this.allocationMaxNetmaskLength;
        }

        public final void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
        }

        @Override
        public final Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        public final Integer getAllocationDefaultNetmaskLength() {
            return this.allocationDefaultNetmaskLength;
        }

        public final void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
        }

        @Override
        public final Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        public final Boolean getClearAllocationDefaultNetmaskLength() {
            return this.clearAllocationDefaultNetmaskLength;
        }

        public final void setClearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
            this.clearAllocationDefaultNetmaskLength = clearAllocationDefaultNetmaskLength;
        }

        @Override
        public final Builder clearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
            this.clearAllocationDefaultNetmaskLength = clearAllocationDefaultNetmaskLength;
            return this;
        }

        public final List<RequestIpamResourceTag.Builder> getAddAllocationResourceTags() {
            List<RequestIpamResourceTag.Builder> result = RequestIpamResourceTagListCopier.copyToBuilder(this.addAllocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddAllocationResourceTags(Collection<RequestIpamResourceTag.BuilderImpl> addAllocationResourceTags) {
            this.addAllocationResourceTags = RequestIpamResourceTagListCopier.copyFromBuilder(addAllocationResourceTags);
        }

        @Override
        public final Builder addAllocationResourceTags(Collection<RequestIpamResourceTag> addAllocationResourceTags) {
            this.addAllocationResourceTags = RequestIpamResourceTagListCopier.copy(addAllocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllocationResourceTags(RequestIpamResourceTag ... addAllocationResourceTags) {
            this.addAllocationResourceTags(Arrays.asList(addAllocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... addAllocationResourceTags) {
            this.addAllocationResourceTags(Stream.of(addAllocationResourceTags).map(c -> (RequestIpamResourceTag)((RequestIpamResourceTag.Builder)RequestIpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RequestIpamResourceTag.Builder> getRemoveAllocationResourceTags() {
            List<RequestIpamResourceTag.Builder> result = RequestIpamResourceTagListCopier.copyToBuilder(this.removeAllocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemoveAllocationResourceTags(Collection<RequestIpamResourceTag.BuilderImpl> removeAllocationResourceTags) {
            this.removeAllocationResourceTags = RequestIpamResourceTagListCopier.copyFromBuilder(removeAllocationResourceTags);
        }

        @Override
        public final Builder removeAllocationResourceTags(Collection<RequestIpamResourceTag> removeAllocationResourceTags) {
            this.removeAllocationResourceTags = RequestIpamResourceTagListCopier.copy(removeAllocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllocationResourceTags(RequestIpamResourceTag ... removeAllocationResourceTags) {
            this.removeAllocationResourceTags(Arrays.asList(removeAllocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... removeAllocationResourceTags) {
            this.removeAllocationResourceTags(Stream.of(removeAllocationResourceTags).map(c -> (RequestIpamResourceTag)((RequestIpamResourceTag.Builder)RequestIpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpamPoolRequest build() {
            return new ModifyIpamPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpamPoolRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPoolId(String var1);

        public Builder description(String var1);

        public Builder autoImport(Boolean var1);

        public Builder allocationMinNetmaskLength(Integer var1);

        public Builder allocationMaxNetmaskLength(Integer var1);

        public Builder allocationDefaultNetmaskLength(Integer var1);

        public Builder clearAllocationDefaultNetmaskLength(Boolean var1);

        public Builder addAllocationResourceTags(Collection<RequestIpamResourceTag> var1);

        public Builder addAllocationResourceTags(RequestIpamResourceTag ... var1);

        public Builder addAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... var1);

        public Builder removeAllocationResourceTags(Collection<RequestIpamResourceTag> var1);

        public Builder removeAllocationResourceTags(RequestIpamResourceTag ... var1);

        public Builder removeAllocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

