/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVerifiedAccessTrustProviderRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessTrustProviderId").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::verifiedAccessTrustProviderId)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::verifiedAccessTrustProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId").unmarshallLocationName("VerifiedAccessTrustProviderId").build()}).build();
    private static final SdkField<ModifyVerifiedAccessTrustProviderOidcOptions> OIDC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OidcOptions").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::oidcOptions)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::oidcOptions)).constructor(ModifyVerifiedAccessTrustProviderOidcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions").unmarshallLocationName("OidcOptions").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::description)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::dryRun)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ModifyVerifiedAccessTrustProviderRequest.getter(ModifyVerifiedAccessTrustProviderRequest::clientToken)).setter(ModifyVerifiedAccessTrustProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, OIDC_OPTIONS_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD));
    private final String verifiedAccessTrustProviderId;
    private final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
    private final String description;
    private final Boolean dryRun;
    private final String clientToken;

    private ModifyVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.oidcOptions = builder.oidcOptions;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
    }

    public final String verifiedAccessTrustProviderId() {
        return this.verifiedAccessTrustProviderId;
    }

    public final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions() {
        return this.oidcOptions;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        ModifyVerifiedAccessTrustProviderRequest other = (ModifyVerifiedAccessTrustProviderRequest)((Object)obj);
        return Objects.equals(this.verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId()) && Objects.equals(this.oidcOptions(), other.oidcOptions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVerifiedAccessTrustProviderRequest").add("VerifiedAccessTrustProviderId", (Object)this.verifiedAccessTrustProviderId()).add("OidcOptions", (Object)this.oidcOptions()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessTrustProviderId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviderId()));
            }
            case "OidcOptions": {
                return Optional.ofNullable(clazz.cast(this.oidcOptions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessTrustProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String verifiedAccessTrustProviderId;
        private ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;
        private String description;
        private Boolean dryRun;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessTrustProviderRequest model) {
            super(model);
            this.verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            this.oidcOptions(model.oidcOptions);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.clientToken(model.clientToken);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return this.verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final ModifyVerifiedAccessTrustProviderOidcOptions.Builder getOidcOptions() {
            return this.oidcOptions != null ? this.oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessTrustProviderRequest build() {
            return new ModifyVerifiedAccessTrustProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVerifiedAccessTrustProviderRequest> {
        public Builder verifiedAccessTrustProviderId(String var1);

        public Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions var1);

        default public Builder oidcOptions(Consumer<ModifyVerifiedAccessTrustProviderOidcOptions.Builder> oidcOptions) {
            return this.oidcOptions((ModifyVerifiedAccessTrustProviderOidcOptions)((ModifyVerifiedAccessTrustProviderOidcOptions.Builder)ModifyVerifiedAccessTrustProviderOidcOptions.builder().applyMutation(oidcOptions)).build());
        }

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

