/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.DefaultEc2AsyncClient;
import software.amazon.awssdk.services.ec2.DefaultEc2BaseClientBuilder;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.Ec2AsyncClientBuilder;
import software.amazon.awssdk.services.ec2.Ec2ServiceClientConfiguration;
import software.amazon.awssdk.services.ec2.endpoints.Ec2EndpointProvider;

@SdkInternalApi
final class DefaultEc2AsyncClientBuilder
extends DefaultEc2BaseClientBuilder<Ec2AsyncClientBuilder, Ec2AsyncClient>
implements Ec2AsyncClientBuilder {
    DefaultEc2AsyncClientBuilder() {
    }

    @Override
    public DefaultEc2AsyncClientBuilder endpointProvider(Ec2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Ec2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEc2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        Ec2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEc2AsyncClient client = new DefaultEc2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private Ec2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return Ec2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

