/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class MoveByoipCidrToIpamRequest extends Ec2Request implements
        ToCopyableBuilder<MoveByoipCidrToIpamRequest.Builder, MoveByoipCidrToIpamRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(MoveByoipCidrToIpamRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(MoveByoipCidrToIpamRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<String> IPAM_POOL_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolOwner")
            .getter(getter(MoveByoipCidrToIpamRequest::ipamPoolOwner))
            .setter(setter(Builder::ipamPoolOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolOwner")
                    .unmarshallLocationName("IpamPoolOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            IPAM_POOL_ID_FIELD, IPAM_POOL_OWNER_FIELD));

    private final String cidr;

    private final String ipamPoolId;

    private final String ipamPoolOwner;

    private MoveByoipCidrToIpamRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.ipamPoolId = builder.ipamPoolId;
        this.ipamPoolOwner = builder.ipamPoolOwner;
    }

    /**
     * <p>
     * The BYOIP CIDR.
     * </p>
     * 
     * @return The BYOIP CIDR.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The IPAM pool ID.
     * </p>
     * 
     * @return The IPAM pool ID.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the owner of the IPAM pool.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the owner of the IPAM pool.
     */
    public final String ipamPoolOwner() {
        return ipamPoolOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoveByoipCidrToIpamRequest)) {
            return false;
        }
        MoveByoipCidrToIpamRequest other = (MoveByoipCidrToIpamRequest) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(ipamPoolId(), other.ipamPoolId())
                && Objects.equals(ipamPoolOwner(), other.ipamPoolOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MoveByoipCidrToIpamRequest").add("Cidr", cidr()).add("IpamPoolId", ipamPoolId())
                .add("IpamPoolOwner", ipamPoolOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "IpamPoolOwner":
            return Optional.ofNullable(clazz.cast(ipamPoolOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MoveByoipCidrToIpamRequest, T> g) {
        return obj -> g.apply((MoveByoipCidrToIpamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, MoveByoipCidrToIpamRequest> {
        /**
         * <p>
         * The BYOIP CIDR.
         * </p>
         * 
         * @param cidr
         *        The BYOIP CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The IPAM pool ID.
         * </p>
         * 
         * @param ipamPoolId
         *        The IPAM pool ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * The Amazon Web Services account ID of the owner of the IPAM pool.
         * </p>
         * 
         * @param ipamPoolOwner
         *        The Amazon Web Services account ID of the owner of the IPAM pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolOwner(String ipamPoolOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidr;

        private String ipamPoolId;

        private String ipamPoolOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(MoveByoipCidrToIpamRequest model) {
            super(model);
            cidr(model.cidr);
            ipamPoolId(model.ipamPoolId);
            ipamPoolOwner(model.ipamPoolOwner);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getIpamPoolOwner() {
            return ipamPoolOwner;
        }

        public final void setIpamPoolOwner(String ipamPoolOwner) {
            this.ipamPoolOwner = ipamPoolOwner;
        }

        @Override
        public final Builder ipamPoolOwner(String ipamPoolOwner) {
            this.ipamPoolOwner = ipamPoolOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MoveByoipCidrToIpamRequest build() {
            return new MoveByoipCidrToIpamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
