/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceTypesFromInstanceRequirementsRequest extends Ec2Request
        implements
        ToCopyableBuilder<GetInstanceTypesFromInstanceRequirementsRequest.Builder, GetInstanceTypesFromInstanceRequirementsRequest> {
    private static final SdkField<List<String>> ARCHITECTURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ArchitectureTypes")
            .getter(getter(GetInstanceTypesFromInstanceRequirementsRequest::architectureTypesAsStrings))
            .setter(setter(Builder::architectureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitectureType")
                    .unmarshallLocationName("ArchitectureType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> VIRTUALIZATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VirtualizationTypes")
            .getter(getter(GetInstanceTypesFromInstanceRequirementsRequest::virtualizationTypesAsStrings))
            .setter(setter(Builder::virtualizationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("VirtualizationType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<InstanceRequirementsRequest> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements")
            .getter(getter(GetInstanceTypesFromInstanceRequirementsRequest::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(InstanceRequirementsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements")
                    .unmarshallLocationName("InstanceRequirements").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(GetInstanceTypesFromInstanceRequirementsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(GetInstanceTypesFromInstanceRequirementsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_TYPES_FIELD,
            VIRTUALIZATION_TYPES_FIELD, INSTANCE_REQUIREMENTS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> architectureTypes;

    private final List<String> virtualizationTypes;

    private final InstanceRequirementsRequest instanceRequirements;

    private final Integer maxResults;

    private final String nextToken;

    private GetInstanceTypesFromInstanceRequirementsRequest(BuilderImpl builder) {
        super(builder);
        this.architectureTypes = builder.architectureTypes;
        this.virtualizationTypes = builder.virtualizationTypes;
        this.instanceRequirements = builder.instanceRequirements;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The processor architecture type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectureTypes} method.
     * </p>
     * 
     * @return The processor architecture type.
     */
    public final List<ArchitectureType> architectureTypes() {
        return ArchitectureTypeSetCopier.copyStringToEnum(architectureTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ArchitectureTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectureTypes() {
        return architectureTypes != null && !(architectureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The processor architecture type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectureTypes} method.
     * </p>
     * 
     * @return The processor architecture type.
     */
    public final List<String> architectureTypesAsStrings() {
        return architectureTypes;
    }

    /**
     * <p>
     * The virtualization type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualizationTypes} method.
     * </p>
     * 
     * @return The virtualization type.
     */
    public final List<VirtualizationType> virtualizationTypes() {
        return VirtualizationTypeSetCopier.copyStringToEnum(virtualizationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualizationTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualizationTypes() {
        return virtualizationTypes != null && !(virtualizationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtualization type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualizationTypes} method.
     * </p>
     * 
     * @return The virtualization type.
     */
    public final List<String> virtualizationTypesAsStrings() {
        return virtualizationTypes;
    }

    /**
     * <p>
     * The attributes required for the instance types.
     * </p>
     * 
     * @return The attributes required for the instance types.
     */
    public final InstanceRequirementsRequest instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. To get the next page of items, make another request with
     * the token returned in the output. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination">Pagination</a>.
     * </p>
     * 
     * @return The maximum number of items to return for this request. To get the next page of items, make another
     *         request with the token returned in the output. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
     *         >Pagination</a>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token returned from a previous paginated request. Pagination continues from the end of the items returned by
     * the previous request.
     * </p>
     * 
     * @return The token returned from a previous paginated request. Pagination continues from the end of the items
     *         returned by the previous request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectureTypes() ? architectureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualizationTypes() ? virtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceTypesFromInstanceRequirementsRequest)) {
            return false;
        }
        GetInstanceTypesFromInstanceRequirementsRequest other = (GetInstanceTypesFromInstanceRequirementsRequest) obj;
        return hasArchitectureTypes() == other.hasArchitectureTypes()
                && Objects.equals(architectureTypesAsStrings(), other.architectureTypesAsStrings())
                && hasVirtualizationTypes() == other.hasVirtualizationTypes()
                && Objects.equals(virtualizationTypesAsStrings(), other.virtualizationTypesAsStrings())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceTypesFromInstanceRequirementsRequest")
                .add("ArchitectureTypes", hasArchitectureTypes() ? architectureTypesAsStrings() : null)
                .add("VirtualizationTypes", hasVirtualizationTypes() ? virtualizationTypesAsStrings() : null)
                .add("InstanceRequirements", instanceRequirements()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchitectureTypes":
            return Optional.ofNullable(clazz.cast(architectureTypesAsStrings()));
        case "VirtualizationTypes":
            return Optional.ofNullable(clazz.cast(virtualizationTypesAsStrings()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceTypesFromInstanceRequirementsRequest, T> g) {
        return obj -> g.apply((GetInstanceTypesFromInstanceRequirementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, GetInstanceTypesFromInstanceRequirementsRequest> {
        /**
         * <p>
         * The processor architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The processor architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypesWithStrings(Collection<String> architectureTypes);

        /**
         * <p>
         * The processor architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The processor architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypesWithStrings(String... architectureTypes);

        /**
         * <p>
         * The processor architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The processor architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypes(Collection<ArchitectureType> architectureTypes);

        /**
         * <p>
         * The processor architecture type.
         * </p>
         * 
         * @param architectureTypes
         *        The processor architecture type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectureTypes(ArchitectureType... architectureTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypesWithStrings(String... virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes);

        /**
         * <p>
         * The virtualization type.
         * </p>
         * 
         * @param virtualizationTypes
         *        The virtualization type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationTypes(VirtualizationType... virtualizationTypes);

        /**
         * <p>
         * The attributes required for the instance types.
         * </p>
         * 
         * @param instanceRequirements
         *        The attributes required for the instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements);

        /**
         * <p>
         * The attributes required for the instance types.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceRequirementsRequest.Builder}
         * avoiding the need to create one manually via {@link InstanceRequirementsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceRequirementsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceRequirements(InstanceRequirementsRequest)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on {@link InstanceRequirementsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(InstanceRequirementsRequest)
         */
        default Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return instanceRequirements(InstanceRequirementsRequest.builder().applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The maximum number of items to return for this request. To get the next page of items, make another request
         * with the token returned in the output. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         * >Pagination</a>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. To get the next page of items, make another
         *        request with the token returned in the output. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination"
         *        >Pagination</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token returned from a previous paginated request. Pagination continues from the end of the items returned
         * by the previous request.
         * </p>
         * 
         * @param nextToken
         *        The token returned from a previous paginated request. Pagination continues from the end of the items
         *        returned by the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> architectureTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> virtualizationTypes = DefaultSdkAutoConstructList.getInstance();

        private InstanceRequirementsRequest instanceRequirements;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceTypesFromInstanceRequirementsRequest model) {
            super(model);
            architectureTypesWithStrings(model.architectureTypes);
            virtualizationTypesWithStrings(model.virtualizationTypes);
            instanceRequirements(model.instanceRequirements);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getArchitectureTypes() {
            if (architectureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return architectureTypes;
        }

        public final void setArchitectureTypes(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
        }

        @Override
        public final Builder architectureTypesWithStrings(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectureTypesWithStrings(String... architectureTypes) {
            architectureTypesWithStrings(Arrays.asList(architectureTypes));
            return this;
        }

        @Override
        public final Builder architectureTypes(Collection<ArchitectureType> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copyEnumToString(architectureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectureTypes(ArchitectureType... architectureTypes) {
            architectureTypes(Arrays.asList(architectureTypes));
            return this;
        }

        public final Collection<String> getVirtualizationTypes() {
            if (virtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return virtualizationTypes;
        }

        public final void setVirtualizationTypes(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
        }

        @Override
        public final Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualizationTypesWithStrings(String... virtualizationTypes) {
            virtualizationTypesWithStrings(Arrays.asList(virtualizationTypes));
            return this;
        }

        @Override
        public final Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copyEnumToString(virtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualizationTypes(VirtualizationType... virtualizationTypes) {
            virtualizationTypes(Arrays.asList(virtualizationTypes));
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceTypesFromInstanceRequirementsRequest build() {
            return new GetInstanceTypesFromInstanceRequirementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
