/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVerifiedAccessTrustProviderResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteVerifiedAccessTrustProviderResponse.Builder, DeleteVerifiedAccessTrustProviderResponse> {
    private static final SdkField<VerifiedAccessTrustProvider> VERIFIED_ACCESS_TRUST_PROVIDER_FIELD = SdkField
            .<VerifiedAccessTrustProvider> builder(MarshallingType.SDK_POJO)
            .memberName("VerifiedAccessTrustProvider")
            .getter(getter(DeleteVerifiedAccessTrustProviderResponse::verifiedAccessTrustProvider))
            .setter(setter(Builder::verifiedAccessTrustProvider))
            .constructor(VerifiedAccessTrustProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProvider")
                    .unmarshallLocationName("verifiedAccessTrustProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VERIFIED_ACCESS_TRUST_PROVIDER_FIELD));

    private final VerifiedAccessTrustProvider verifiedAccessTrustProvider;

    private DeleteVerifiedAccessTrustProviderResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProvider = builder.verifiedAccessTrustProvider;
    }

    /**
     * <p>
     * The ID of the Verified Access trust provider.
     * </p>
     * 
     * @return The ID of the Verified Access trust provider.
     */
    public final VerifiedAccessTrustProvider verifiedAccessTrustProvider() {
        return verifiedAccessTrustProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVerifiedAccessTrustProviderResponse)) {
            return false;
        }
        DeleteVerifiedAccessTrustProviderResponse other = (DeleteVerifiedAccessTrustProviderResponse) obj;
        return Objects.equals(verifiedAccessTrustProvider(), other.verifiedAccessTrustProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVerifiedAccessTrustProviderResponse")
                .add("VerifiedAccessTrustProvider", verifiedAccessTrustProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessTrustProvider":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVerifiedAccessTrustProviderResponse, T> g) {
        return obj -> g.apply((DeleteVerifiedAccessTrustProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVerifiedAccessTrustProviderResponse> {
        /**
         * <p>
         * The ID of the Verified Access trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProvider
         *        The ID of the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProvider(VerifiedAccessTrustProvider verifiedAccessTrustProvider);

        /**
         * <p>
         * The ID of the Verified Access trust provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessTrustProvider.Builder}
         * avoiding the need to create one manually via {@link VerifiedAccessTrustProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessTrustProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #verifiedAccessTrustProvider(VerifiedAccessTrustProvider)}.
         * 
         * @param verifiedAccessTrustProvider
         *        a consumer that will call methods on {@link VerifiedAccessTrustProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifiedAccessTrustProvider(VerifiedAccessTrustProvider)
         */
        default Builder verifiedAccessTrustProvider(Consumer<VerifiedAccessTrustProvider.Builder> verifiedAccessTrustProvider) {
            return verifiedAccessTrustProvider(VerifiedAccessTrustProvider.builder().applyMutation(verifiedAccessTrustProvider)
                    .build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private VerifiedAccessTrustProvider verifiedAccessTrustProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVerifiedAccessTrustProviderResponse model) {
            super(model);
            verifiedAccessTrustProvider(model.verifiedAccessTrustProvider);
        }

        public final VerifiedAccessTrustProvider.Builder getVerifiedAccessTrustProvider() {
            return verifiedAccessTrustProvider != null ? verifiedAccessTrustProvider.toBuilder() : null;
        }

        public final void setVerifiedAccessTrustProvider(VerifiedAccessTrustProvider.BuilderImpl verifiedAccessTrustProvider) {
            this.verifiedAccessTrustProvider = verifiedAccessTrustProvider != null ? verifiedAccessTrustProvider.build() : null;
        }

        @Override
        public final Builder verifiedAccessTrustProvider(VerifiedAccessTrustProvider verifiedAccessTrustProvider) {
            this.verifiedAccessTrustProvider = verifiedAccessTrustProvider;
            return this;
        }

        @Override
        public DeleteVerifiedAccessTrustProviderResponse build() {
            return new DeleteVerifiedAccessTrustProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
