/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationFleetState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityReservationFleetCancellationState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityReservationFleetCancellationState> {
    private static final SdkField<String> CURRENT_FLEET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentFleetState").getter(CapacityReservationFleetCancellationState.getter(CapacityReservationFleetCancellationState::currentFleetStateAsString)).setter(CapacityReservationFleetCancellationState.setter(Builder::currentFleetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFleetState").unmarshallLocationName("currentFleetState").build()}).build();
    private static final SdkField<String> PREVIOUS_FLEET_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousFleetState").getter(CapacityReservationFleetCancellationState.getter(CapacityReservationFleetCancellationState::previousFleetStateAsString)).setter(CapacityReservationFleetCancellationState.setter(Builder::previousFleetState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousFleetState").unmarshallLocationName("previousFleetState").build()}).build();
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationFleetId").getter(CapacityReservationFleetCancellationState.getter(CapacityReservationFleetCancellationState::capacityReservationFleetId)).setter(CapacityReservationFleetCancellationState.setter(Builder::capacityReservationFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId").unmarshallLocationName("capacityReservationFleetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_FLEET_STATE_FIELD, PREVIOUS_FLEET_STATE_FIELD, CAPACITY_RESERVATION_FLEET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currentFleetState;
    private final String previousFleetState;
    private final String capacityReservationFleetId;

    private CapacityReservationFleetCancellationState(BuilderImpl builder) {
        this.currentFleetState = builder.currentFleetState;
        this.previousFleetState = builder.previousFleetState;
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
    }

    public final CapacityReservationFleetState currentFleetState() {
        return CapacityReservationFleetState.fromValue(this.currentFleetState);
    }

    public final String currentFleetStateAsString() {
        return this.currentFleetState;
    }

    public final CapacityReservationFleetState previousFleetState() {
        return CapacityReservationFleetState.fromValue(this.previousFleetState);
    }

    public final String previousFleetStateAsString() {
        return this.previousFleetState;
    }

    public final String capacityReservationFleetId() {
        return this.capacityReservationFleetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousFleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationFleetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityReservationFleetCancellationState)) {
            return false;
        }
        CapacityReservationFleetCancellationState other = (CapacityReservationFleetCancellationState)obj;
        return Objects.equals(this.currentFleetStateAsString(), other.currentFleetStateAsString()) && Objects.equals(this.previousFleetStateAsString(), other.previousFleetStateAsString()) && Objects.equals(this.capacityReservationFleetId(), other.capacityReservationFleetId());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityReservationFleetCancellationState").add("CurrentFleetState", (Object)this.currentFleetStateAsString()).add("PreviousFleetState", (Object)this.previousFleetStateAsString()).add("CapacityReservationFleetId", (Object)this.capacityReservationFleetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentFleetState": {
                return Optional.ofNullable(clazz.cast(this.currentFleetStateAsString()));
            }
            case "PreviousFleetState": {
                return Optional.ofNullable(clazz.cast(this.previousFleetStateAsString()));
            }
            case "CapacityReservationFleetId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityReservationFleetCancellationState, T> g) {
        return obj -> g.apply((CapacityReservationFleetCancellationState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentFleetState;
        private String previousFleetState;
        private String capacityReservationFleetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityReservationFleetCancellationState model) {
            this.currentFleetState(model.currentFleetState);
            this.previousFleetState(model.previousFleetState);
            this.capacityReservationFleetId(model.capacityReservationFleetId);
        }

        public final String getCurrentFleetState() {
            return this.currentFleetState;
        }

        public final void setCurrentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
        }

        @Override
        @Transient
        public final Builder currentFleetState(String currentFleetState) {
            this.currentFleetState = currentFleetState;
            return this;
        }

        @Override
        @Transient
        public final Builder currentFleetState(CapacityReservationFleetState currentFleetState) {
            this.currentFleetState(currentFleetState == null ? null : currentFleetState.toString());
            return this;
        }

        public final String getPreviousFleetState() {
            return this.previousFleetState;
        }

        public final void setPreviousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
        }

        @Override
        @Transient
        public final Builder previousFleetState(String previousFleetState) {
            this.previousFleetState = previousFleetState;
            return this;
        }

        @Override
        @Transient
        public final Builder previousFleetState(CapacityReservationFleetState previousFleetState) {
            this.previousFleetState(previousFleetState == null ? null : previousFleetState.toString());
            return this;
        }

        public final String getCapacityReservationFleetId() {
            return this.capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        @Transient
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public CapacityReservationFleetCancellationState build() {
            return new CapacityReservationFleetCancellationState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityReservationFleetCancellationState> {
        public Builder currentFleetState(String var1);

        public Builder currentFleetState(CapacityReservationFleetState var1);

        public Builder previousFleetState(String var1);

        public Builder previousFleetState(CapacityReservationFleetState var1);

        public Builder capacityReservationFleetId(String var1);
    }
}

